/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Delimiters;
import org.trimou.engine.parser.ParsedTag;
import org.trimou.engine.parser.Parser;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

class DefaultParser
implements Parser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParser.class);
    private MustacheEngine engine;
    private State state = State.TEXT;
    private int line = 1;
    private int delimiterIdx = 0;
    private boolean triple = false;
    private StringBuilder buffer = new StringBuilder();
    private final Delimiters delimiters;
    private ParsingHandler handler;
    private final Set<String> supportedSeparators;
    private List<String> lastMatchedSeparators;
    private Set<Character> zeroIndexNonSeparatorCharacters;
    private int separatorIdx = 0;

    public DefaultParser(MustacheEngine engine) {
        this.engine = engine;
        this.delimiters = new Delimiters(engine.getConfiguration().getStringPropertyValue(EngineConfigurationKey.START_DELIMITER), engine.getConfiguration().getStringPropertyValue(EngineConfigurationKey.END_DELIMITER));
        this.supportedSeparators = ImmutableSet.of((Object)"\n", (Object)"\r", (Object)"\r\n");
        this.zeroIndexNonSeparatorCharacters = new HashSet<Character>();
    }

    @Override
    public void parse(String name, Reader reader, ParsingHandler handler) {
        Checker.checkArgumentNotEmpty(name);
        Checker.checkArgumentsNotNull(reader, handler);
        this.handler = handler;
        reader = this.ensureBufferedReader(reader);
        try {
            int val;
            handler.startTemplate(name, this.delimiters, this.engine);
            while ((val = reader.read()) != -1) {
                this.processCharacter((char)val);
            }
            if (this.buffer.length() > 0) {
                if (this.state == State.TEXT) {
                    this.flushText();
                } else {
                    throw new MustacheException(MustacheProblem.COMPILE_INVALID_TEMPLATE, "Unexpected non-text buffer at the end of the document (probably unterminated tag): %s", this.buffer);
                }
            }
            if (this.state == State.LINE_SEPARATOR) {
                this.lineSeparatorFound(this.lastMatchedSeparators.get(0));
            }
            handler.endTemplate();
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.COMPILE_IO_ERROR, (Throwable)e);
        }
    }

    private void processCharacter(char character) {
        switch (this.state) {
            case TEXT: {
                this.text(character);
                break;
            }
            case START_TAG: {
                this.startTag(character);
                break;
            }
            case TAG: {
                this.tag(character);
                break;
            }
            case END_TAG: {
                this.endTag(character);
                break;
            }
            case LINE_SEPARATOR: {
                this.lineSeparator(character);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown parsing state");
            }
        }
    }

    private void text(char character) {
        if (character == this.delimiters.getStart(0)) {
            if (this.delimiters.isStartOver(this.delimiterIdx)) {
                this.tagStartFound();
            } else {
                this.state = State.START_TAG;
                this.delimiterIdx = 1;
            }
        } else {
            this.lastMatchedSeparators = this.findMatchingSeparators(character, 0);
            if (this.lastMatchedSeparators.size() > 0) {
                if (this.lastMatchedSeparators.size() == 1 && this.lastMatchedSeparators.get(0).length() == 1) {
                    this.lineSeparatorFound(this.lastMatchedSeparators.get(0));
                } else if (this.lastMatchedSeparators.size() > 1 || this.lastMatchedSeparators.size() == 1 && this.lastMatchedSeparators.get(0).length() > 1) {
                    this.state = State.LINE_SEPARATOR;
                    this.separatorIdx = 1;
                }
            } else {
                this.buffer.append(character);
            }
        }
    }

    private void startTag(char character) {
        if (character == this.delimiters.getStart(this.delimiterIdx)) {
            if (this.delimiters.isStartOver(this.delimiterIdx)) {
                this.tagStartFound();
            } else {
                ++this.delimiterIdx;
            }
        } else {
            this.state = State.TEXT;
            this.buffer.append(this.delimiters.getStartPart(this.delimiterIdx));
            this.delimiterIdx = 0;
            this.processCharacter(character);
        }
    }

    private void tag(char character) {
        if (character == this.delimiters.getEnd(0)) {
            if (this.triple) {
                this.buffer.append(character);
                this.triple = false;
            } else if (this.delimiters.isEndOver(this.delimiterIdx)) {
                this.flushTag();
            } else {
                this.state = State.END_TAG;
                this.delimiterIdx = 1;
            }
        } else {
            if (character == this.delimiters.getStart(0) && this.buffer.length() == 0) {
                this.triple = true;
            }
            this.buffer.append(character);
        }
    }

    private void endTag(char character) {
        if (character == this.delimiters.getEnd(this.delimiterIdx)) {
            if (this.delimiters.isEndOver(this.delimiterIdx)) {
                this.flushTag();
            } else {
                ++this.delimiterIdx;
            }
        } else {
            logger.warn("Tag contains part of the end delimiter - most probably an invalid key [part: {}, line: {}]", (Object)this.delimiters.getStartPart(this.delimiterIdx), (Object)this.line);
            this.state = State.TAG;
            this.buffer.append(this.delimiters.getEndPart(this.delimiterIdx));
            this.buffer.append(character);
            this.delimiterIdx = 0;
        }
    }

    private void lineSeparator(char character) {
        List<String> matched = this.findMatchingSeparators(character, this.separatorIdx);
        if (matched.isEmpty()) {
            for (String separator : this.lastMatchedSeparators) {
                if (separator.length() != this.separatorIdx) continue;
                this.lineSeparatorFound(separator);
                this.processCharacter(character);
            }
        } else if (matched.size() == 1) {
            this.lineSeparatorFound(matched.get(0));
        } else if (matched.size() > 1) {
            this.lastMatchedSeparators = matched;
            ++this.separatorIdx;
        }
    }

    private void lineSeparatorFound(String lineSeparator) {
        this.flushText();
        this.flushLineSeparator(lineSeparator);
        ++this.line;
        this.state = State.TEXT;
        this.separatorIdx = 0;
    }

    private void tagStartFound() {
        this.state = State.TAG;
        this.delimiterIdx = 0;
        this.flushText();
    }

    private void flushText() {
        if (this.buffer.length() > 0) {
            this.handler.text(this.buffer.toString());
            this.clearBuffer();
        }
    }

    private void flushTag() {
        this.state = State.TEXT;
        this.handler.tag(this.deriveTag(this.buffer.toString()));
        this.delimiterIdx = 0;
        this.clearBuffer();
    }

    private void flushLineSeparator(String separator) {
        this.handler.lineSeparator(separator);
    }

    private Reader ensureBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }

    private ParsedTag deriveTag(String buffer) {
        MustacheTagType type = this.identifyTagType(buffer);
        String key = this.extractContent(type, buffer);
        return new ParsedTag(key, type);
    }

    private MustacheTagType identifyTagType(String buffer) {
        if (buffer.length() == 0) {
            return MustacheTagType.VARIABLE;
        }
        if (this.delimiters.hasDefaultDelimitersSet() && buffer.charAt(0) == ((String)EngineConfigurationKey.START_DELIMITER.getDefaultValue()).charAt(0) && buffer.charAt(buffer.length() - 1) == ((String)EngineConfigurationKey.END_DELIMITER.getDefaultValue()).charAt(0)) {
            return MustacheTagType.UNESCAPE_VARIABLE;
        }
        Character command = Character.valueOf(buffer.charAt(0));
        for (MustacheTagType type : MustacheTagType.values()) {
            if (!command.equals(type.getCommand())) continue;
            return type;
        }
        return MustacheTagType.VARIABLE;
    }

    private String extractContent(MustacheTagType tagType, String buffer) {
        switch (tagType) {
            case VARIABLE: {
                return buffer.trim();
            }
            case UNESCAPE_VARIABLE: {
                return buffer.charAt(0) == ((String)EngineConfigurationKey.START_DELIMITER.getDefaultValue()).charAt(0) ? buffer.substring(1, buffer.length() - 1).trim() : buffer.substring(1).trim();
            }
            case SECTION: 
            case INVERTED_SECTION: 
            case PARTIAL: 
            case EXTEND: 
            case EXTEND_SECTION: 
            case SECTION_END: 
            case NESTED_TEMPLATE: 
            case COMMENT: {
                return buffer.substring(1).trim();
            }
            case DELIMITER: {
                return buffer.trim();
            }
        }
        return null;
    }

    private void clearBuffer() {
        this.buffer = new StringBuilder();
    }

    private List<String> findMatchingSeparators(char character, int atIndex) {
        if (atIndex == 0 && this.zeroIndexNonSeparatorCharacters.contains(Character.valueOf(character))) {
            return Collections.emptyList();
        }
        ArrayList<String> matchedSeparators = new ArrayList<String>(this.supportedSeparators.size());
        for (String separator : this.supportedSeparators) {
            if (separator.length() <= atIndex || separator.charAt(atIndex) != character) continue;
            matchedSeparators.add(separator);
        }
        if (atIndex == 0 && matchedSeparators.isEmpty()) {
            this.zeroIndexNonSeparatorCharacters.add(Character.valueOf(character));
        }
        return matchedSeparators;
    }

    private static enum State {
        TEXT,
        START_TAG,
        TAG,
        END_TAG,
        LINE_SEPARATOR;

    }
}

