/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Delimiters;
import org.trimou.engine.parser.ParsedTag;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.parser.SegmentBases;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.CommentSegment;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.ExtendSegment;
import org.trimou.engine.segment.InvertedSectionSegment;
import org.trimou.engine.segment.LineSeparatorSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.PartialSegment;
import org.trimou.engine.segment.RootSegment;
import org.trimou.engine.segment.SectionSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.SetDelimitersSegment;
import org.trimou.engine.segment.TextSegment;
import org.trimou.engine.segment.ValueSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Patterns;

class DefaultParsingHandler
implements ParsingHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParsingHandler.class);
    private final Deque<ContainerSegmentBase> containerStack = new ArrayDeque<ContainerSegmentBase>();
    private final List<Template> nestedTemplates = new ArrayList<Template>();
    private MustacheEngine engine;
    private String templateName;
    private Delimiters delimiters;
    private Template template;
    private long start;
    private int line = 1;
    private int index = 0;
    private boolean skipValueEscaping;
    private boolean handlebarsSupportEnabled;
    private NestedTemplateBase currentNestedBase;

    DefaultParsingHandler() {
    }

    @Override
    public void startTemplate(String name, Delimiters delimiters, MustacheEngine engine) {
        this.delimiters = delimiters;
        this.engine = engine;
        this.templateName = name;
        this.containerStack.addFirst(new RootSegmentBase());
        this.skipValueEscaping = engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.SKIP_VALUE_ESCAPING);
        this.handlebarsSupportEnabled = engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED);
        this.start = System.currentTimeMillis();
        logger.debug("Start compilation of {}", new Object[]{name});
    }

    @Override
    public void endTemplate() {
        RootSegmentBase rootSegmentBase = this.validate();
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_STANDALONE_LINES).booleanValue()) {
            SegmentBases.removeStandaloneLines(rootSegmentBase);
        }
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REMOVE_UNNECESSARY_SEGMENTS).booleanValue()) {
            SegmentBases.removeUnnecessarySegments(rootSegmentBase);
        }
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.REUSE_LINE_SEPARATOR_SEGMENTS).booleanValue()) {
            SegmentBases.reuseLineSeparatorSegments(rootSegmentBase);
        }
        this.template = new Template(this.engine.getConfiguration().getIdentifierGenerator().generate(Mustache.class), this.templateName, this.engine, this.nestedTemplates);
        this.template.setRootSegment(rootSegmentBase.asSegment(this.template));
        for (Template nested : this.nestedTemplates) {
            nested.setParent(this.template);
        }
        logger.debug("Compilation of {} finished [time: {} ms, segments: {}]", new Object[]{this.templateName, System.currentTimeMillis() - this.start, this.template.getRootSegment().getSegmentsSize(true)});
        rootSegmentBase = null;
        this.nestedTemplates.clear();
        this.containerStack.clear();
    }

    @Override
    public void text(String text) {
        this.addSegment(new SegmentBase(SegmentType.TEXT, text, this.line, this.incrementAndGetIndex()));
    }

    @Override
    public void tag(ParsedTag tag) {
        this.validateTag(tag);
        switch (tag.getType()) {
            case COMMENT: {
                this.addSegment(new SegmentBase(tag, this.line, this.incrementAndGetIndex()));
                break;
            }
            case UNESCAPE_VARIABLE: 
            case VARIABLE: {
                this.valueSegment(tag);
                break;
            }
            case PARTIAL: {
                this.addSegment(new PartialSegmentBase(tag, this.line, this.incrementAndGetIndex()));
                break;
            }
            case DELIMITER: {
                this.changeDelimiters(tag.getContent());
                this.addSegment(new SegmentBase(tag, this.line, this.incrementAndGetIndex()));
                break;
            }
            case SECTION: 
            case INVERTED_SECTION: 
            case EXTEND: 
            case EXTEND_SECTION: {
                this.push(new ContainerSegmentBase(tag, this.line, this.incrementAndGetIndex()));
                break;
            }
            case NESTED_TEMPLATE: {
                this.nestedTemplate(tag);
                break;
            }
            case SECTION_END: {
                this.endSection(tag.getContent());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported tag type");
            }
        }
    }

    @Override
    public void lineSeparator(String separator) {
        this.addSegment(new LineSeparatorBase(separator, this.line, this.incrementAndGetIndex()));
        ++this.line;
    }

    @Override
    public Mustache getCompiledTemplate() {
        if (this.template == null) {
            throw new MustacheException(MustacheProblem.TEMPLATE_NOT_READY);
        }
        return this.template;
    }

    private void validateTag(ParsedTag tag) {
        if (StringUtils.isEmpty((CharSequence)tag.getContent())) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_TAG, "Tag has no content [type: %s, line: %s]", new Object[]{tag.getType(), this.line});
        }
        if (tag.getContent().contains(this.delimiters.getStart())) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_TAG, "Tag content contains current start delimiter [type: %s, line: %s, delimiter: %s]", new Object[]{tag.getType(), this.line, this.delimiters.getStart()});
        }
        if (this.handlebarsSupportEnabled) {
            if (MustacheTagType.contentMustBeValidated(tag.getType()) && !MustacheTagType.supportsHelpers(tag.getType()) && StringUtils.containsWhitespace((CharSequence)tag.getContent())) {
                this.contentMustBeNonWhitespaceSequenceException(tag.getType());
            }
        } else if (MustacheTagType.contentMustBeNonWhitespaceCharacterSequence(tag.getType()) && StringUtils.containsWhitespace((CharSequence)tag.getContent())) {
            this.contentMustBeNonWhitespaceSequenceException(tag.getType());
        }
    }

    private MustacheException contentMustBeNonWhitespaceSequenceException(MustacheTagType tagType) {
        throw new MustacheException(MustacheProblem.COMPILE_INVALID_TAG, "Tag content must be a non-whitespace character sequence [template: %s, type: %s, line: %s]", new Object[]{this.templateName, tagType, this.line});
    }

    private void endSection(String key) {
        ContainerSegmentBase container = this.pop();
        if (container == null || SegmentType.ROOT.equals((Object)container.getType()) || !this.handlebarsSupportEnabled && !key.equals(container.getContent()) || this.handlebarsSupportEnabled && !container.getContent().startsWith(key) || this.handlebarsSupportEnabled && !container.getContent().contains(" ") && !key.equals(container.getContent())) {
            StringBuilder msg = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            msg.append("Invalid section end: ");
            if (container == null || SegmentType.ROOT.equals((Object)container.getType())) {
                msg.append("%s has no matching section start");
                params.add(key);
            } else {
                msg.append("%s is not matching section start %s");
                params.add(key);
                params.add(container.getContent());
            }
            msg.append(" [line: %s]");
            params.add("" + this.line);
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_SECTION_END, msg.toString(), params.toArray());
        }
        if (container instanceof NestedTemplateBase) {
            NestedTemplateBase nestedBase = (NestedTemplateBase)container;
            Template nested = new Template(this.engine.getConfiguration().getIdentifierGenerator().generate(Mustache.class), container.getContent(), this.engine);
            nested.setRootSegment(nestedBase.asSegment(nested));
            this.nestedTemplates.add(nested);
            this.currentNestedBase = null;
        } else {
            this.addSegment(container);
        }
    }

    private void changeDelimiters(String key) {
        if (key.charAt(0) != MustacheTagType.DELIMITER.getCommand().charValue() || key.charAt(key.length() - 1) != MustacheTagType.DELIMITER.getCommand().charValue()) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_DELIMITERS, "Invalid set delimiters tag: %s [line: %s]", key, this.line);
        }
        Matcher matcher = Patterns.newSetDelimitersContentPattern().matcher(key.substring(1, key.length() - 1));
        if (!matcher.find()) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_DELIMITERS, "Invalid delimiters set: %s [line: %s]", key, this.line);
        }
        this.delimiters.setNewValues(matcher.group(1), matcher.group(3));
    }

    private void push(ContainerSegmentBase container) {
        this.containerStack.addFirst(container);
        logger.trace("Push {} [name: {}]", (Object)container.getType(), (Object)container.getContent());
    }

    private ContainerSegmentBase pop() {
        ContainerSegmentBase container = this.containerStack.removeFirst();
        logger.trace("Pop {} [name: {}]", (Object)container.getType(), (Object)container.getContent());
        return container;
    }

    private void addSegment(SegmentBase segment) {
        this.containerStack.peekFirst().addSegment(segment);
        logger.trace("Add {}", (Object)segment);
    }

    private RootSegmentBase validate() {
        ContainerSegmentBase root = this.containerStack.peekFirst();
        if (!(root instanceof RootSegmentBase)) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_TEMPLATE, "Incorrect last container segment on the stack: %s", this.containerStack.peekFirst().toString(), this.line);
        }
        return (RootSegmentBase)root;
    }

    private int incrementAndGetIndex() {
        return ++this.index;
    }

    private void valueSegment(ParsedTag tag) {
        this.addSegment(new ValueSegmentBase(tag, this.line, this.incrementAndGetIndex(), this.skipValueEscaping));
    }

    private void nestedTemplate(ParsedTag tag) {
        if (this.engine.getConfiguration().getBooleanPropertyValue(EngineConfigurationKey.NESTED_TEMPLATE_SUPPORT_ENABLED).booleanValue()) {
            for (Template nested : this.nestedTemplates) {
                if (!nested.getName().equals(tag.getContent())) continue;
                throw new MustacheException(MustacheProblem.COMPILE_NESTED_TEMPLATE_ERROR, "A nested template with the name [%s] is already defined at line %s in the template [%s]", tag.getContent(), nested.getRootSegment().getOrigin().getLine(), this.templateName);
            }
            NestedTemplateBase nestedBase = new NestedTemplateBase(tag.getContent(), this.line, this.index);
            if (this.currentNestedBase != null) {
                throw new MustacheException(MustacheProblem.COMPILE_NESTED_TEMPLATE_ERROR, "Nested templates within nested template definitions are not supported: %s", this.containerStack.peekFirst().toString());
            }
            this.currentNestedBase = nestedBase;
            this.push(nestedBase);
        } else {
            this.valueSegment(new ParsedTag(MustacheTagType.NESTED_TEMPLATE.getCommand() + tag.getContent(), MustacheTagType.VARIABLE));
        }
    }

    static class SegmentBase {
        private final SegmentType type;
        private final String content;
        private final int line;
        private final int index;

        SegmentBase(ParsedTag tag, int line, int index) {
            this.content = tag.getContent();
            this.type = SegmentType.fromTag(tag.getType());
            this.line = line;
            this.index = index;
        }

        SegmentBase(SegmentType type, String content, int line, int index) {
            this.type = type;
            this.content = content;
            this.line = line;
            this.index = index;
        }

        SegmentType getType() {
            return this.type;
        }

        String getContent() {
            return this.content;
        }

        int getLine() {
            return this.line;
        }

        int getIndex() {
            return this.index;
        }

        Segment asSegment(Template template) {
            switch (this.type) {
                case TEXT: {
                    return new TextSegment(this.content, this.getOrigin(template));
                }
                case COMMENT: {
                    return new CommentSegment(this.content, this.getOrigin(template));
                }
                case DELIMITERS: {
                    return new SetDelimitersSegment(this.content, this.getOrigin(template));
                }
            }
            throw new IllegalStateException("Unsupported segment type: " + (Object)((Object)this.type));
        }

        protected Origin getOrigin(Template template) {
            return new Origin(template, this.line, this.index);
        }

        public String toString() {
            return String.format("[type: %s, content: %s, line: %s, idx: %s]", new Object[]{this.type, this.content, this.line, this.index});
        }
    }

    static class PartialSegmentBase
    extends SegmentBase {
        private String indentation;

        PartialSegmentBase(ParsedTag tag, int line, int index) {
            super(tag, line, index);
        }

        public void setIndentation(String indentation) {
            this.indentation = indentation;
        }

        @Override
        public PartialSegment asSegment(Template template) {
            return new PartialSegment(this.getContent(), this.getOrigin(template), this.indentation);
        }
    }

    static class ValueSegmentBase
    extends SegmentBase {
        private boolean unescape;

        ValueSegmentBase(ParsedTag tag, int line, int index, boolean skipValueEscaping) {
            super(SegmentType.VALUE, tag.getContent(), line, index);
            this.unescape = skipValueEscaping ? true : tag.getType().equals((Object)MustacheTagType.UNESCAPE_VARIABLE);
        }

        @Override
        ValueSegment asSegment(Template template) {
            return new ValueSegment(this.getContent(), this.getOrigin(template), this.unescape);
        }
    }

    static class LineSeparatorBase
    extends SegmentBase {
        private LineSeparatorSegment segment;

        public LineSeparatorBase(String content, int line, int index) {
            super(SegmentType.LINE_SEPARATOR, content, line, index);
        }

        @Override
        Segment asSegment(Template template) {
            if (this.segment == null) {
                this.segment = new LineSeparatorSegment(this.getContent(), this.getOrigin(template));
            }
            return this.segment;
        }
    }

    static class ContainerSegmentBase
    extends SegmentBase
    implements Iterable<SegmentBase> {
        private final List<SegmentBase> segments = new ArrayList<SegmentBase>();

        ContainerSegmentBase(SegmentType type, String content, int line, int index) {
            super(type, content, line, index);
        }

        ContainerSegmentBase(ParsedTag tag, int line, int index) {
            super(tag, line, index);
        }

        boolean addSegment(SegmentBase segment) {
            if (SegmentType.EXTEND.equals((Object)this.getType()) && !SegmentType.EXTEND_SECTION.equals((Object)segment.getType())) {
                return false;
            }
            return this.segments.add(segment);
        }

        @Override
        ContainerSegment asSegment(Template template) {
            switch (this.getType()) {
                case SECTION: {
                    return new SectionSegment(this.getContent(), this.getOrigin(template), this.getSegments(template));
                }
                case INVERTED_SECTION: {
                    return new InvertedSectionSegment(this.getContent(), this.getOrigin(template), this.getSegments(template));
                }
                case EXTEND: {
                    return new ExtendSegment(this.getContent(), this.getOrigin(template), this.getSegments(template));
                }
                case EXTEND_SECTION: {
                    return new ExtendSectionSegment(this.getContent(), this.getOrigin(template), this.getSegments(template));
                }
            }
            throw new IllegalStateException("Invalid tag type: " + (Object)((Object)this.getType()));
        }

        protected List<Segment> getSegments(Template template) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SegmentBase wrapper : this.segments) {
                builder.add((Object)wrapper.asSegment(template));
            }
            return builder.build();
        }

        @Override
        public Iterator<SegmentBase> iterator() {
            return this.segments.iterator();
        }

        ListIterator<SegmentBase> listIterator() {
            return this.segments.listIterator();
        }
    }

    static class NestedTemplateBase
    extends ContainerSegmentBase {
        NestedTemplateBase(String content, int line, int index) {
            super(null, content, line, index);
        }

        @Override
        public RootSegment asSegment(Template template) {
            return new RootSegment(new Origin(template, this.getLine(), this.getIndex()), this.getSegments(template));
        }
    }

    static class RootSegmentBase
    extends ContainerSegmentBase {
        RootSegmentBase() {
            super(SegmentType.ROOT, null, 0, 0);
        }

        @Override
        public RootSegment asSegment(Template template) {
            return new RootSegment(new Origin(template), this.getSegments(template));
        }
    }
}

