/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.util.Map;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.Mapper;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.ThisResolver;

public class MapResolver
extends AbstractResolver {
    public static final int MAP_RESOLVER_PRIORITY = Priorities.rightAfter(ThisResolver.THIS_RESOLVER_PRIORITY);
    private final EnhancedResolver.Hint hint = new EnhancedResolver.Hint(){

        @Override
        public Object resolve(Object contextObject, String name, ResolutionContext context) {
            return MapResolver.this.resolve(contextObject, name, context);
        }
    };

    public MapResolver() {
        this(MAP_RESOLVER_PRIORITY);
    }

    public MapResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null) {
            return null;
        }
        if (contextObject instanceof Map) {
            Map map = (Map)contextObject;
            return map.get(name);
        }
        if (contextObject instanceof Mapper) {
            Mapper mapper = (Mapper)contextObject;
            return mapper.get(name);
        }
        return null;
    }

    @Override
    public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
        return this.hint;
    }
}

