/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.resolver.EnhancedResolver;

class ValueProvider {
    private final String key;
    private final String[] keyParts;
    private final AtomicReference<EnhancedResolver.Hint> hint;

    ValueProvider(String text, Configuration configuration) {
        this.key = text;
        ArrayList<String> parts = new ArrayList<String>();
        Iterator<String> iterator = configuration.getKeySplitter().split(text);
        while (iterator.hasNext()) {
            parts.add(iterator.next());
        }
        this.keyParts = parts.toArray(new String[parts.size()]);
        this.hint = configuration.getBooleanPropertyValue(EngineConfigurationKey.RESOLVER_HINTS_ENABLED) != false ? new AtomicReference() : null;
    }

    ValueWrapper get(ExecutionContext context) {
        ValueWrapper value = context.getValue(this.key, this.keyParts, this.hint);
        if (this.hint != null && value.getHint() != null) {
            this.hint.compareAndSet(null, value.getHint());
        }
        return value;
    }
}

