/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.NumericExpressionHelper;
import org.trimou.handlebars.Options;

public class AlternativesHelper
extends BasicHelper {
    private static final Logger logger = LoggerFactory.getLogger(AlternativesHelper.class);
    private final Selector selector;

    public AlternativesHelper() {
        this(new ConditionSelector());
    }

    public AlternativesHelper(Selector selector) {
        this.selector = selector;
    }

    @Override
    public void execute(Options options) {
        Object value = this.selector.select(options);
        if (this.isSection(options)) {
            if (value != null) {
                options.push(value);
                options.fn();
                options.pop();
            }
        } else {
            if (value == null) {
                value = this.configuration.getMissingValueHandler().handle(options.getTagInfo());
            }
            if (value != null) {
                this.append(options, value.toString());
            }
        }
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        if (definition.getParameters().size() == 1) {
            logger.warn("{} is not really useful for single parameter [template: {}, line: {}]", new Object[]{this.getClass().getSimpleName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return NO_SUPPORTED_HASH_KEYS;
    }

    public static interface Selector {
        public Object select(Options var1);
    }

    public static class MaxSelector
    implements Selector {
        public static final String DEFAULT_NAME = "max";

        @Override
        public Object select(Options options) {
            BigDecimal max = null;
            Object selected = null;
            for (Object param : options.getParameters()) {
                BigDecimal paramDecimal = NumericExpressionHelper.getDecimal(param, options);
                if (max != null && paramDecimal.compareTo(max) <= 0) continue;
                max = paramDecimal;
                selected = param;
            }
            return selected;
        }
    }

    public static class MinSelector
    implements Selector {
        public static final String DEFAULT_NAME = "min";

        @Override
        public Object select(Options options) {
            BigDecimal min = null;
            Object selected = null;
            for (Object param : options.getParameters()) {
                BigDecimal paramDecimal = NumericExpressionHelper.getDecimal(param, options);
                if (min != null && paramDecimal.compareTo(min) >= 0) continue;
                min = paramDecimal;
                selected = param;
            }
            return selected;
        }
    }

    public static class ConditionSelector
    implements Selector {
        private final Condition condition;

        public ConditionSelector() {
            this(new Condition(){

                @Override
                public boolean matches(Object param) {
                    if (param == null) {
                        return false;
                    }
                    if (param instanceof String) {
                        return !param.toString().isEmpty();
                    }
                    return true;
                }
            });
        }

        public ConditionSelector(Condition condition) {
            this.condition = condition;
        }

        @Override
        public Object select(Options options) {
            for (Object param : options.getParameters()) {
                if (!this.condition.matches(param)) continue;
                return param;
            }
            return null;
        }

        public static interface Condition {
            public boolean matches(Object var1);
        }
    }
}

