/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.handlebars.i18n.AbstractTimeFormatHelper;

public class DateTimeFormatHelper
extends AbstractTimeFormatHelper<Object, Integer> {
    @Override
    protected String defaultFormat(Object value, Locale locale, TimeZone timeZone) {
        return this.format(value, 2, locale, timeZone);
    }

    @Override
    protected String format(Object value, Integer style, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(style, style, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(value);
    }

    @Override
    protected String format(Object value, String pattern, Locale locale, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(value);
    }

    @Override
    protected Object getFormattableObject(Object value, Locale locale, TimeZone timeZone, MustacheTagInfo tagInfo) {
        if (value instanceof Date || value instanceof Number) {
            return value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        throw this.valueNotAFormattableObject(value, tagInfo);
    }

    @Override
    protected Integer parseStyle(String style, MustacheTagInfo tagInfo) {
        if ("full".equals(style)) {
            return 0;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        throw this.unknownStyle(style, tagInfo);
    }
}

