/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.Options;

public class EnhancedResolverTest
extends AbstractTest {
    @Test
    public void testHint() {
        final ArrayList resolvedNames = new ArrayList();
        final ArrayList hintNames = new ArrayList();
        final AtomicInteger hintCounter = new AtomicInteger();
        AbstractResolver resolver = new AbstractResolver(10){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                resolvedNames.add(name);
                return true;
            }

            public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
                return new EnhancedResolver.Hint(){

                    public Object resolve(Object contextObject, String name, ResolutionContext context) {
                        hintCounter.incrementAndGet();
                        if (hintCounter.get() <= 2) {
                            hintNames.add(name);
                            return false;
                        }
                        return null;
                    }
                };
            }
        };
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Mustache mustache = engine.compileMustache("enhancedresolver_1", "{{foo}}");
        Assert.assertEquals((Object)"true", (Object)mustache.render(null));
        Assert.assertEquals((Object)"false", (Object)mustache.render(null));
        Assert.assertEquals((Object)"false", (Object)mustache.render(null));
        Assert.assertEquals((Object)"true", (Object)mustache.render(null));
        Assert.assertEquals((long)2L, (long)resolvedNames.size());
        Assert.assertEquals((long)2L, (long)hintNames.size());
    }

    @Test
    public void testHintIsOnlyUsedForTheFirstPartOfKey() {
        final ArrayList resolvedNames = new ArrayList();
        final ArrayList hintNames = new ArrayList();
        final AtomicInteger hintCounter = new AtomicInteger();
        final Hammer hammer1 = new Hammer(10);
        final Hammer hammer2 = new Hammer(20);
        AbstractResolver resolver = new AbstractResolver(10){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                resolvedNames.add(name);
                if (contextObject == null) {
                    return hammer1;
                }
                if (contextObject instanceof Hammer) {
                    return ((Hammer)contextObject).getAge();
                }
                return null;
            }

            public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
                return new EnhancedResolver.Hint(){

                    public Object resolve(Object contextObject, String name, ResolutionContext context) {
                        hintCounter.incrementAndGet();
                        if (hintCounter.get() <= 2) {
                            hintNames.add(name);
                            return hammer2;
                        }
                        return null;
                    }
                };
            }
        };
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Mustache mustache = engine.compileMustache("enhancedresolver_2", "{{foo.bar}}");
        Assert.assertEquals((Object)"10", (Object)mustache.render(null));
        Assert.assertEquals((Object)"20", (Object)mustache.render(null));
        Assert.assertEquals((Object)"20", (Object)mustache.render(null));
        Assert.assertEquals((Object)"10", (Object)mustache.render(null));
        Assert.assertEquals((long)6L, (long)resolvedNames.size());
        Assert.assertEquals((long)2L, (long)hintNames.size());
    }

    @Test
    public void testHintIsNotCreatedForHelper() {
        final AtomicBoolean hintCreate = new AtomicBoolean(false);
        AbstractResolver resolver = new AbstractResolver(10){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                return true;
            }

            public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
                hintCreate.set(true);
                return null;
            }
        };
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).registerHelper("foo", (Helper)new BasicHelper(){

            public void execute(Options options) {
                this.append(options, options.getValue("foo").toString());
            }
        }).build();
        Mustache mustache = engine.compileMustache("enhancedresolver_helper1", "{{foo 'bar'}}");
        Assert.assertEquals((Object)"true", (Object)mustache.render(null));
        Assert.assertFalse((boolean)hintCreate.get());
    }
}

