/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.ImmutableMap;

public class PartialSegmentTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testRecursiveInvocationLimitExceeded() {
        MapTemplateLocator locator = new MapTemplateLocator(ImmutableMap.of((Object)"part", (Object)"{{>part}}", (Object)"alpha", (Object)"{{>bravo}}", (Object)"bravo", (Object)"{{>alpha}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, (Object)5).build();
        try {
            engine.getMustache("part").render(null);
            Assert.fail((String)"Limit exceeded and no exception thrown");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
        try {
            engine.getMustache("alpha").render(null);
            Assert.fail((String)"Limit exceeded and no exception thrown");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testRecursiveInvocationDisabled() {
        MapTemplateLocator locator = new MapTemplateLocator(ImmutableMap.of((Object)"node", (Object)"{{content}}<{{#nodes}}{{>node}}{{/nodes}}>"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, (Object)0).build();
        Map data = ImmutableMap.of((Object)"content", (Object)"X", (Object)"nodes", (Object)new Map[]{ImmutableMap.of((Object)"content", (Object)"Y", (Object)"nodes", (Object)new Map[]{ImmutableMap.of((Object)"content", (Object)"Z", (Object)"nodes", (Object)new Map[0])})});
        try {
            engine.getMustache("node").render((Object)data);
            Assert.fail((String)"Limit exceeded and no exception thrown");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testRecursiveInvocationAllowed() {
        MapTemplateLocator locator = new MapTemplateLocator(ImmutableMap.of((Object)"node", (Object)"{{content}}<{{#nodes}}{{>node}}{{/nodes}}>"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Map data = ImmutableMap.of((Object)"content", (Object)"X", (Object)"nodes", (Object)new Map[]{ImmutableMap.of((Object)"content", (Object)"Y", (Object)"nodes", (Object)new Map[]{ImmutableMap.of((Object)"content", (Object)"Z", (Object)"nodes", (Object)new Map[0])})});
        Assert.assertEquals((Object)"X<Y<Z<>>>", (Object)engine.getMustache("node").render((Object)data));
    }

    @Test
    public void testPartialNotFound() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().build();
        try {
            engine.compileMustache("partial_not_found", "Hello,\n this partial \n\n {{>neverexisted}}").render(null);
            Assert.fail((String)"Partial does not exist!");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_INVALID_PARTIAL_KEY)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testTemplateInvocationsStack() {
        String partial = "!";
        StringBuilder template = new StringBuilder();
        StringBuilder result = new StringBuilder();
        int loop = 2 * Integer.valueOf(EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT.getDefaultValue().toString());
        for (int i = 0; i < loop; ++i) {
            template.append("{{> partial}}");
            result.append(partial);
        }
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)template.toString(), (Object)"partial", (Object)partial.toString()))).build();
        Assert.assertEquals((Object)result.toString(), (Object)engine.getMustache("template").render(null));
    }

    @Test
    public void testCachedPartialSegmentUsed() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alpha", "{{>bravo}}");
        map.put("bravo", "{{this}}");
        MapTemplateLocator locator = new MapTemplateLocator(map);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache mustache = engine.getMustache("alpha");
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
        map.put("bravo", "NOTHING");
        engine.invalidateTemplateCache();
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
    }

    @Test
    public void testCachedPartialSegmentNotUsed() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alpha", "{{>bravo}}");
        map.put("bravo", "{{this}}");
        MapTemplateLocator locator = new MapTemplateLocator(map);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.DEBUG_MODE, (Object)true).build();
        Mustache mustache = engine.getMustache("alpha");
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
        map.put("bravo", "NOTHING");
        Assert.assertEquals((Object)"NOTHING", (Object)mustache.render((Object)"foo"));
    }
}

