/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.handlebars.EmbedHelper;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableMap;

public class EmbedHelperTest
extends AbstractTest {
    @Test
    public void testEmbeddedHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addEmbed().build()).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)"Hello!"))).build();
        Assert.assertEquals((Object)"<script id=\"template\" type=\"text/template\">\nHello!\n</script>", (Object)engine.compileMustache("embed_helper01", "{{embed this}}").render((Object)"template"));
        Assert.assertEquals((Object)"<script id=\"template\" type=\"text/template\">\nHello!\n</script>", (Object)engine.compileMustache("embed_helper01", "{{embed 'temp' this}}").render((Object)"late"));
    }

    @Test
    public void testCustomSourceProcessor() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addEmbed(new EmbedHelper.SourceProcessor(){

            public String process(String mustacheName, String mustacheSource) {
                return "<source>" + mustacheSource + "</source>";
            }
        }).build()).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)"{{foo}}"))).build();
        Assert.assertEquals((Object)"<source>{{foo}}</source>", (Object)engine.compileMustache("embed_helper02", "{{embed 'template'}}").render(null));
    }
}

