/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableMap;

public class IncludeHelperTest
extends AbstractTest {
    @Test
    public void testIncludeHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInclude().build()).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)"Hello!"))).build();
        Assert.assertEquals((Object)"Hello!", (Object)engine.compileMustache("include_helper01", "{{include this}}").render((Object)"template"));
        Assert.assertEquals((Object)"Hello!", (Object)engine.compileMustache("include_helper02", "{{include 'temp' this}}").render((Object)"late"));
    }

    @Test
    public void testIncludeHelperValidation() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInclude().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("include_helper_validation01", "{{include}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("set_helper_validation02", "{{#include \"foo\"}}{{/include}}");
            }
        });
    }
}

