/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.ArchiveType;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.interpolation.NoOpMissingValueHandler;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;

public class InvokeHelperTest
extends AbstractTest {
    @Test
    public void testHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInvoke().build()).build();
        List list = ImmutableList.of((Object[])new String[]{"foo", "bar", "baz"});
        Map data = ImmutableMap.of((Object)"string", (Object)"foo", (Object)"list", (Object)list);
        Assert.assertEquals((Object)"oo", (Object)engine.compileMustache("invoke_01", "{{invoke 1 m='substring'}}").render((Object)"foo"));
        Assert.assertEquals((Object)"bar", (Object)engine.compileMustache("invoke_02", "{{invoke 1 m='get'}}").render((Object)list));
        Assert.assertEquals((Object)"FOOBARBAZ", (Object)engine.compileMustache("invoke_03", "{{#invoke 'list' m='get'}}{{#each this}}{{toUpperCase}}{{/each}}{{/invoke}}").render((Object)data));
        Assert.assertEquals((Object)"3", (Object)engine.compileMustache("invoke_04", "{{invoke on=list m='size'}}").render((Object)data));
        Assert.assertEquals((Object)"false", (Object)engine.compileMustache("invoke_05", "{{invoke on=list method='isEmpty'}}").render((Object)data));
        Assert.assertEquals((Object)"boo", (Object)engine.compileMustache("invoke_06", "{{invoke 'f' 'b' on='foo' m='replace'}}").render(null));
        Assert.assertEquals((Object)"2", (Object)engine.compileMustache("invoke_07", "{{#invoke ':' on='foo:bar' m='split'}}{{this.length}}{{/invoke}}").render(null));
    }

    @Test
    public void testStaticMethod() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInvoke().build()).build();
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        list.add("baz");
        Assert.assertEquals((Object)"bazbarfoo", (Object)engine.compileMustache("invoke_static_01", "{{invoke this class='java.util.Collections' m='reverse'}}{{#each this}}{{this}}{{/each}}").render(list));
        Assert.assertEquals((Object)"war", (Object)engine.compileMustache("invoke_static_02", "{{#invoke 'WAR' class='org.trimou.ArchiveType' m='valueOf'}}{{suffix}}{{/invoke}}").render(null));
        Assert.assertEquals((Object)"1", (Object)engine.compileMustache("invoke_static_03", "{{#invoke 'MILLISECONDS' class='java.util.concurrent.TimeUnit' m='valueOf'}}{{invoke 1000l m='toSeconds'}}{{/invoke}}").render(null));
        Assert.assertEquals((Object)"war", (Object)engine.compileMustache("invoke_static_04", "{{#invoke 'WAR' class=this m='valueOf'}}{{suffix}}{{/invoke}}").render(ArchiveType.class));
    }

    @Test
    public void testValidation() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInvoke().build()).build().compileMustache("invoke_validation_01", "{{invoke 'foo' on=this}}");
            }
        });
    }

    @Test
    public void testMissingValueHandler() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setMissingValueHandler((MissingValueHandler)new NoOpMissingValueHandler(){

            public Object handle(MustacheTagInfo tagInfo) {
                return "foo";
            }
        }).registerHelpers(HelpersBuilder.empty().addInvoke().build()).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("invoke_missing_01", "{{invoke m='getNull'}}").render((Object)new Hammer()));
    }

    @Test
    public void testRenderingErrors() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInvoke().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("invoke_method_not_found", "{{invoke m='foo'}}").render((Object)"bar");
            }
        });
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("invoke_method_ambiguous", "{{invoke 'name' 5L class='java.lang.Long' m='getLong'}}").render((Object)"bar");
            }
        });
    }
}

