/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableList;

public class RepeatHelperTest
extends AbstractTest {
    @Test
    public void testHelper() throws InterruptedException {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().addInvoke().build()).build();
        Assert.assertEquals((Object)"mememe", (Object)engine.compileMustache("repeat_01", "{{#repeat times=3}}me{{/repeat}}").render(null));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("repeat_02", "{{#repeat while=this}}me{{/repeat}}").render((Object)false));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_GENERIC_ERROR).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("repeat_03", "{{#repeat while='this' limit=3}}me{{/repeat}}").render((Object)true);
            }
        });
        Assert.assertEquals((Object)"foobar", (Object)engine.compileMustache("repeat_04", "{{#with this.iterator}}{{#repeat while=hasNext}}{{next}}{{/repeat}}{{/with}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar"})));
        Assert.assertEquals((Object)"barfoo", (Object)engine.compileMustache("repeat_05", "{{#invoke this.size on=this m='listIterator'}}{{#repeat while=hasPrevious}}{{previous}}{{/repeat}}{{/invoke}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar"})));
    }

    @Test
    public void testValidation() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_01", "{{repeat}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_02", "{{#repeat foo='bar'}}{{/repeat}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_03", "{{#repeat times='a'}}{{/repeat}}");
            }
        });
    }
}

