/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableMap;

public class SetHelperTest
extends AbstractTest {
    @Test
    public void testSetHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSet().build()).build();
        Assert.assertEquals((Object)"hellohello", (Object)engine.compileMustache("set_helper01", "{{foo}}{{bar}}{{#set foo=\"hello\"}}{{foo}}{{bar}}{{#set bar=foo}}{{bar}}{{/set}}{{/set}}{{foo}}{{bar}}").render(null));
        Assert.assertEquals((Object)"helloping1", (Object)engine.compileMustache("set_helper02", "{{#set foo=\"hello\" bar=\"ping\" qux=one}}{{foo}}{{bar}}{{qux}}{{/set}}").render((Object)ImmutableMap.of((Object)"one", (Object)BigDecimal.ONE)));
    }

    @Test
    public void testSetHelperValidation() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSet().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("set_helper_validation01", "{{#set}}{{/set}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("set_helper_validation02", "{{#set \"foo\"}}{{/set}}");
            }
        });
    }
}

