/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.SimpleHelpers;

public class SimpleHelperTest {
    @Test
    public void testSimpleHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("lc", SimpleHelpers.execute((o, c) -> {
            String value = o.getParameters().get(0).toString();
            o.append((CharSequence)value.toLowerCase());
        })).registerHelper("lc_validate", SimpleHelpers.builder().execute((o, c) -> o.append((CharSequence)o.getParameters().get(0).toString().toLowerCase())).validate((d, c) -> {
            if (d.getParameters().isEmpty()) {
                throw new MustacheException((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
            }
        }).build()).build();
        Assert.assertEquals((Object)"ok", (Object)engine.compileMustache("simple_helper_01", "{{lc 'OK'}}").render(null));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("simple_helper_02", "{{lc_validate}}").render(null));
    }

    @Test
    public void testSimpleHelperConfiguration() {
        SimpleConfigurationKey key = new SimpleConfigurationKey("test.key", (Object)10L);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", SimpleHelpers.builder().execute((o, c) -> o.append((CharSequence)c.getLongPropertyValue((ConfigurationKey)key).toString())).addConfigurationKey((ConfigurationKey)key).build()).build();
        Assert.assertEquals((Object)"10", (Object)engine.compileMustache("simple_helper_config_01", "{{test}}").render(null));
    }
}

