/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.util.Collections;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locale.FixedLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.i18n.ResourceBundleHelper;
import org.trimou.util.ImmutableMap;

public class ResourceBundleHelperTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
        this.engine = MustacheEngineBuilder.newBuilder().setLocaleSupport((LocaleSupport)FixedLocaleSupport.from((Locale)Locale.ENGLISH)).registerHelper("msg", (Helper)new ResourceBundleHelper("messages")).build();
    }

    @Test
    public void testInterpolation() {
        String templateContents = "{{msg \"echo_one\"}},{{msg \"echo.two\"}},{{msg key}}";
        Mustache mustache = this.engine.compileMustache("bundle_helper", templateContents);
        Assert.assertEquals((Object)"Hello,Hey,echo", (Object)mustache.render((Object)ImmutableMap.of((Object)"key", (Object)"echo")));
        Assert.assertEquals((Object)"Hello", (Object)this.engine.compileMustache("bundle_helper2", "{{msg 'echo_one'}}").render(null));
    }

    @Test
    public void testBaseName() {
        String templateContents = "{{msg \"test.key.bravo\" baseName=\"trimou\"}}";
        Mustache mustache = this.engine.compileMustache("bundle_helper_basename", templateContents);
        Assert.assertEquals((Object)"42", (Object)mustache.render(null));
    }

    @Test
    public void testFormat() {
        block2: {
            String defaultFormat = "{{msg \"echo.printf\" \"Martin\"}}";
            String none = "{{msg \"echo.printf\" format=\"none\"}}";
            String printf = "{{msg \"echo.printf\" \"Martin\" format=\"printf\"}}";
            String message = "{{msg \"echo.messageformat\" \"Martin\" format=\"message\"}}";
            String unsupported = "{{msg \"echo.printf\" \"Martin\" format=\"berserk\"}}";
            String wrongArguments = "{{msg \"echo.printf\"}}";
            Assert.assertEquals((Object)"Hello Martin!", (Object)this.engine.compileMustache("bundle_helper_defaultFormat", defaultFormat).render(null));
            Assert.assertEquals((Object)"Hello %s!", (Object)this.engine.compileMustache("bundle_helper_defaultFormat", none).render(null));
            Assert.assertEquals((Object)"Hello Martin!", (Object)this.engine.compileMustache("bundle_helper_printf", printf).render(null));
            Assert.assertEquals((Object)"Hello Martin!", (Object)this.engine.compileMustache("bundle_helper_message", message).render(null));
            Assert.assertEquals((Object)"Hello Martin!", (Object)this.engine.compileMustache("bundle_helper_unsupported", unsupported).render(null));
            try {
                this.engine.compileMustache("bundle_helper_wrongArguments", wrongArguments).render(null);
                Assert.fail();
            }
            catch (MustacheException e) {
                if (e.getCode().equals(MustacheProblem.RENDER_IO_ERROR)) break block2;
                Assert.fail();
            }
        }
    }

    @Test
    public void testLocale() {
        String templateContents = "{{msg \"echo_one\" locale='de'}},{{msg \"echo.two\" locale=myLocale}},{{msg key locale='de'}}";
        Mustache mustache = this.engine.compileMustache("bundle_helper_locale_01", templateContents);
        Assert.assertEquals((Object)"Hallo,He,oche", (Object)mustache.render((Object)ImmutableMap.of((Object)"key", (Object)"echo", (Object)"myLocale", (Object)Locale.GERMAN)));
        mustache = this.engine.compileMustache("bundle_helper_locale_02", "{{msg \"echo_one\"}}");
        Assert.assertEquals((Object)"Hallo", (Object)mustache.render(Collections.singletonMap("locale", Locale.GERMAN)));
    }
}

