/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.util.Strings;

public class StringsTest {
    @Test
    public void testReplace() {
        Assert.assertEquals((Object)"foobar", (Object)Strings.replace((String)"foo:bar", (String)":", (String)""));
    }

    @Test
    public void testContainsWhitespace() {
        Assert.assertTrue((boolean)Strings.containsWhitespace((String)"foo bar"));
        Assert.assertTrue((boolean)Strings.containsWhitespace((String)System.getProperty("line.separator")));
        Assert.assertFalse((boolean)Strings.containsWhitespace((String)"foobar"));
    }

    @Test
    public void testContainsOnlyWhitespace() {
        Assert.assertTrue((boolean)Strings.containsOnlyWhitespace((String)"  "));
        Assert.assertTrue((boolean)Strings.containsOnlyWhitespace((String)("  " + System.getProperty("line.separator"))));
        Assert.assertFalse((boolean)Strings.containsOnlyWhitespace((String)" !"));
    }

    @Test
    public void testContainsOnlyDigits() {
        Assert.assertTrue((boolean)Strings.containsOnlyDigits((String)"123"));
        Assert.assertFalse((boolean)Strings.containsOnlyDigits((String)"5!"));
    }

    @Test
    public void testRepeat() {
        Assert.assertEquals((Object)"foo,foo", (Object)Strings.repeat((String)"foo", (int)2, (String)","));
        Assert.assertEquals((Object)"ooo", (Object)Strings.repeat((String)"o", (int)3, (String)""));
        Assert.assertEquals((Object)"o", (Object)Strings.repeat((String)"o", (int)-3, (String)""));
        Assert.assertEquals((Object)"", (Object)Strings.repeat((String)"ouch", (int)0, (String)""));
    }

    @Test
    public void testSubstringAfter() {
        Assert.assertEquals((Object)"o", (Object)Strings.substringAfter((String)"foo", (String)"o"));
        Assert.assertEquals((Object)"", (Object)Strings.substringAfter((String)"foo", (String)"a"));
    }
}

