/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.cache.DefaultComputingCacheFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationAware;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.ConfigurationProperties;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.config.SecurityActions;
import org.trimou.engine.id.IdentifierGenerator;
import org.trimou.engine.id.SequenceIdentifierGenerator;
import org.trimou.engine.interpolation.DefaultLiteralSupport;
import org.trimou.engine.interpolation.DotKeySplitter;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.interpolation.NoOpMissingValueHandler;
import org.trimou.engine.interpolation.ThrowingExceptionMissingValueHandler;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.DefaultLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.DefaultTextSupport;
import org.trimou.engine.text.TextSupport;
import org.trimou.engine.validation.Validateable;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;
import org.trimou.util.Strings;

class DefaultConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfiguration.class);
    private static final String RESOURCE_FILE = "/trimou.properties";
    private final List<TemplateLocator> templateLocators;
    private final List<Resolver> resolvers;
    private final Map<String, Object> globalData;
    private final TextSupport textSupport;
    private final LocaleSupport localeSupport;
    private final Map<String, Object> properties;
    private final List<MustacheListener> mustacheListeners;
    private final KeySplitter keySplitter;
    private final MissingValueHandler missingValueHandler;
    private final Map<String, Helper> helpers;
    private final ComputingCacheFactory computingCacheFactory;
    private final IdentifierGenerator identifierGenerator;
    private final ExecutorService executorService;
    private final LiteralSupport literalSupport;

    DefaultConfiguration(MustacheEngineBuilder builder) {
        if (!builder.isOmitServiceLoaderConfigurationExtensions()) {
            ClassLoader cl = builder.getConfigurationExtensionClassLoader();
            if (cl == null && (cl = SecurityActions.getContextClassLoader()) == null) {
                cl = SecurityActions.getClassLoader(DefaultConfiguration.class);
            }
            ArrayList<ConfigurationExtension> configurationExtensions = new ArrayList<ConfigurationExtension>();
            Iterator<ConfigurationExtension> iterator = ServiceLoader.load(ConfigurationExtension.class, cl).iterator();
            while (iterator.hasNext()) {
                configurationExtensions.add(iterator.next());
            }
            Collections.sort(configurationExtensions, Priorities.higherFirst());
            for (ConfigurationExtension configurationExtension : configurationExtensions) {
                configurationExtension.register(builder);
            }
        }
        List<Resolver> resolvers = this.initResolvers(builder);
        ArrayList<MustacheListener> mustacheListeners = new ArrayList<MustacheListener>(builder.buildMustacheListeners());
        MissingValueHandler missingValueHandler = this.initMissingValueHandler(builder);
        Map<String, Helper> helpers = builder.buildHelpers();
        this.textSupport = this.initTextSupport(builder);
        this.localeSupport = this.initLocaleSupport(builder);
        this.keySplitter = this.initKeySplitter(builder);
        this.templateLocators = this.initTemplateLocators(builder);
        Map<String, Object> globalData = builder.buildGlobalData();
        this.globalData = globalData.isEmpty() ? null : globalData;
        this.computingCacheFactory = builder.getComputingCacheFactory() != null ? builder.getComputingCacheFactory() : new DefaultComputingCacheFactory();
        this.identifierGenerator = builder.getIdentifierGenerator() != null ? builder.getIdentifierGenerator() : new SequenceIdentifierGenerator();
        this.literalSupport = builder.getLiteralSupport() != null ? builder.getLiteralSupport() : new DefaultLiteralSupport();
        LinkedHashSet<ConfigurationAware> components = new LinkedHashSet<ConfigurationAware>();
        components.add(this.computingCacheFactory);
        components.add(this.identifierGenerator);
        components.addAll(resolvers);
        components.add(this.textSupport);
        components.add(this.localeSupport);
        components.add(this.keySplitter);
        components.addAll(this.templateLocators != null ? this.templateLocators : Collections.emptySet());
        components.addAll(mustacheListeners);
        components.addAll(helpers.values());
        components.add(this.literalSupport);
        this.properties = this.initializeProperties(builder, this.getConfigurationKeysToProcess(components));
        if (this.getBooleanPropertyValue(EngineConfigurationKey.NO_VALUE_INDICATES_PROBLEM).booleanValue()) {
            LOGGER.warn("{}.{} is deprecated, use appropriate MissingValueHandler instance instead", (Object)EngineConfigurationKey.class.getSimpleName(), (Object)EngineConfigurationKey.NO_VALUE_INDICATES_PROBLEM);
            this.missingValueHandler = new ThrowingExceptionMissingValueHandler();
        } else {
            this.missingValueHandler = missingValueHandler;
        }
        this.helpers = this.getBooleanPropertyValue(EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED) == false ? Collections.emptyMap() : helpers;
        this.initializeConfigurationAwareComponents(components);
        this.removeInvalidComponents(resolvers);
        this.removeInvalidComponents(mustacheListeners);
        this.resolvers = ImmutableList.copyOf(resolvers);
        this.mustacheListeners = ImmutableList.copyOf(mustacheListeners);
        this.executorService = builder.getExecutorService();
    }

    @Override
    public List<Resolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    @Override
    public List<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    @Override
    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    @Override
    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    @Override
    public List<MustacheListener> getMustacheListeners() {
        return this.mustacheListeners;
    }

    @Override
    public KeySplitter getKeySplitter() {
        return this.keySplitter;
    }

    @Override
    public MissingValueHandler getMissingValueHandler() {
        return this.missingValueHandler;
    }

    @Override
    public Map<String, Helper> getHelpers() {
        return this.helpers;
    }

    @Override
    public <T extends ConfigurationKey> Long getLongPropertyValue(T configurationKey) {
        Long value = (Long)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Long)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public <T extends ConfigurationKey> Integer getIntegerPropertyValue(T configurationKey) {
        Integer value = (Integer)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Integer)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public <T extends ConfigurationKey> String getStringPropertyValue(T configurationKey) {
        Object value = this.properties.get(configurationKey.get());
        if (value == null) {
            value = configurationKey.getDefaultValue();
        }
        return value.toString();
    }

    @Override
    public <T extends ConfigurationKey> Boolean getBooleanPropertyValue(T configurationKey) {
        Boolean value = (Boolean)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Boolean)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public String getInfo() {
        StringBuilder builder = new StringBuilder();
        if (this.templateLocators != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Template locators]");
            for (TemplateLocator templateLocator : this.templateLocators) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(templateLocator.toString());
            }
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
        }
        if (this.resolvers != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Resolvers]");
            for (Resolver resolver : this.resolvers) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(resolver.toString());
            }
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
        }
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[Properties]");
        for (Map.Entry entry : this.properties.entrySet()) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append((String)entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("----------");
        return builder.toString();
    }

    @Override
    public ComputingCacheFactory getComputingCacheFactory() {
        return this.computingCacheFactory;
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public ExecutorService geExecutorService() {
        return this.executorService;
    }

    @Override
    public LiteralSupport getLiteralSupport() {
        return this.literalSupport;
    }

    private void initializeConfigurationAwareComponents(Set<ConfigurationAware> components) {
        for (ConfigurationAware component : components) {
            component.init(this);
        }
    }

    private List<Resolver> initResolvers(MustacheEngineBuilder builder) {
        Set<Resolver> builderResolvers = builder.buildResolvers();
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>();
        if (!builderResolvers.isEmpty()) {
            resolvers.addAll(builderResolvers);
            Collections.sort(resolvers, Priorities.higherFirst());
        }
        return resolvers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> initializeProperties(MustacheEngineBuilder engineBuilder, Set<ConfigurationKey> keysToProcess) {
        Properties resourceProperties;
        Map<String, Object> builderProperties;
        ImmutableMap.ImmutableMapBuilder<String, Object> builder;
        block11: {
            builder = ImmutableMap.builder();
            builderProperties = engineBuilder.buildProperties();
            resourceProperties = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(RESOURCE_FILE);
                if (in == null) break block11;
                try {
                    resourceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (ConfigurationKey configKey : keysToProcess) {
            String key = configKey.get();
            Object value = builderProperties.get(key);
            if (value == null && (value = SecurityActions.getSystemProperty(key)) == null) {
                value = resourceProperties.getProperty(key);
            }
            if (value != null) {
                try {
                    value = ConfigurationProperties.convertConfigValue(configKey.getDefaultValue().getClass(), value);
                }
                catch (Exception e) {
                    throw new MustacheException(MustacheProblem.CONFIG_PROPERTY_INVALID_VALUE, (Throwable)e);
                }
            } else {
                value = configKey.getDefaultValue();
            }
            builder.put(key, value);
        }
        return builder.build();
    }

    private Set<ConfigurationKey> getConfigurationKeysToProcess(Set<ConfigurationAware> components) {
        HashSet<ConfigurationKey> keys = new HashSet<ConfigurationKey>();
        for (EngineConfigurationKey key : EngineConfigurationKey.values()) {
            keys.add(key);
        }
        for (ConfigurationAware component : components) {
            keys.addAll(component.getConfigurationKeys());
        }
        return keys;
    }

    private TextSupport initTextSupport(MustacheEngineBuilder builder) {
        return builder.getTextSupport() != null ? builder.getTextSupport() : new DefaultTextSupport();
    }

    private LocaleSupport initLocaleSupport(MustacheEngineBuilder builder) {
        return builder.getLocaleSupport() != null ? builder.getLocaleSupport() : new DefaultLocaleSupport();
    }

    private KeySplitter initKeySplitter(MustacheEngineBuilder builder) {
        return builder.getKeySplitter() != null ? builder.getKeySplitter() : new DotKeySplitter();
    }

    private MissingValueHandler initMissingValueHandler(MustacheEngineBuilder builder) {
        return builder.getMissingValueHandler() != null ? builder.getMissingValueHandler() : new NoOpMissingValueHandler();
    }

    private List<TemplateLocator> initTemplateLocators(MustacheEngineBuilder builder) {
        Set<TemplateLocator> builderTemplateLocators = builder.buildTemplateLocators();
        if (!builderTemplateLocators.isEmpty()) {
            ArrayList<TemplateLocator> locators = new ArrayList<TemplateLocator>(builder.buildTemplateLocators());
            Collections.sort(locators, Priorities.higherFirst());
            return ImmutableList.copyOf(locators);
        }
        return null;
    }

    private Set<ConfigurationAware> getConfigurationAwareComponents(Set<ConfigurationAware> initialSet) {
        HashSet<ConfigurationAware> components = new HashSet<ConfigurationAware>();
        components.add(this.missingValueHandler);
        components.addAll(this.helpers.values());
        components.addAll(this.resolvers);
        if (this.templateLocators != null) {
            components.addAll(this.templateLocators);
        }
        if (this.mustacheListeners != null) {
            components.addAll(this.mustacheListeners);
        }
        components.add(this.localeSupport);
        components.add(this.textSupport);
        components.add(this.keySplitter);
        return components;
    }

    private <T> void removeInvalidComponents(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T component = iterator.next();
            if (!(component instanceof Validateable) || ((Validateable)component).isValid()) continue;
            iterator.remove();
        }
    }
}

