/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.io.IOException;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.text.TextSupport;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.Helpers;
import org.trimou.handlebars.Options;

public abstract class AbstractHelper
extends AbstractConfigurationAware
implements Helper {
    private volatile TextSupport textSupport;

    @Override
    protected void init() {
        if (!this.configuration.getBooleanPropertyValue(EngineConfigurationKey.SKIP_VALUE_ESCAPING).booleanValue()) {
            this.textSupport = this.configuration.getTextSupport();
        }
    }

    protected boolean isSection(Options options) {
        return Helpers.isSection(options);
    }

    protected boolean isVariable(Options options) {
        return Helpers.isVariable(options);
    }

    protected boolean isUnescapeVariable(Options options) {
        return Helpers.isUnescapeVariable(options);
    }

    protected void append(Options options, CharSequence sequence) {
        TextSupport textSupport = this.textSupport;
        if (textSupport == null || this.isUnescapeVariable(options)) {
            options.append(sequence);
        } else {
            try {
                textSupport.appendEscapedHtml(sequence.toString(), options.getAppendable());
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }
    }
}

