/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.trimou.handlebars.BasicValueHelper;
import org.trimou.handlebars.Options;

public class EmbedHelper
extends BasicValueHelper {
    private final SourceProcessor processor;

    public EmbedHelper() {
        this((name, source) -> "<script id=\"" + name.replace("/", "_") + "\" type=\"text/template\">\n" + source + "\n" + "</script>");
    }

    public EmbedHelper(SourceProcessor sourceProcessor) {
        this.processor = sourceProcessor;
    }

    @Override
    public void execute(Options options) {
        String sourceName;
        if (options.getParameters().size() == 1) {
            sourceName = options.getParameters().get(0).toString();
        } else {
            StringBuilder builder = new StringBuilder();
            for (Object param : options.getParameters()) {
                builder.append(param.toString());
            }
            sourceName = builder.toString();
        }
        options.append(this.processor.process(sourceName, options.source(sourceName)));
    }

    @FunctionalInterface
    public static interface SourceProcessor {
        public String process(String var1, String var2);
    }
}

