/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;

@Internal
public final class Files {
    private static final Logger LOGGER = LoggerFactory.getLogger(Files.class);

    private Files() {
    }

    public static List<File> listFiles(File dir, String suffix) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    files.addAll(Files.listFiles(file, suffix));
                    continue;
                }
                if (!file.isFile() || suffix != null && !file.getName().endsWith(suffix)) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static boolean isDirectoryUsable(File dir) {
        if (!dir.exists()) {
            LOGGER.warn("Dir not usable - does not exist: {}", (Object)dir);
            return false;
        }
        if (!dir.canRead()) {
            LOGGER.warn("Dir not usable - cannot read: {}", (Object)dir);
            return false;
        }
        if (!dir.isDirectory()) {
            LOGGER.warn("Dir not usable - not a directory: {}", (Object)dir);
            return false;
        }
        return true;
    }

    public static boolean isFileUsable(File file) {
        if (!file.exists()) {
            LOGGER.warn("File not usable - does not exist: {}", (Object)file);
            return false;
        }
        if (!file.canRead()) {
            LOGGER.warn("File not usable - cannot read: {}", (Object)file);
            return false;
        }
        if (!file.isFile()) {
            LOGGER.warn("File not usable - not a normal file: {}", (Object)file);
            return false;
        }
        return true;
    }
}

