/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.trimou.Mustache;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ExecutionContexts;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.engine.resource.AbstractReleaseCallbackContainer;
import org.trimou.engine.segment.RootSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.ImmutableMap;

@Internal
public class Template
implements Mustache {
    private final long generatedId;
    private final String name;
    private final MustacheEngine engine;
    private final ExecutionContext globalExecutionContext;
    private final Map<String, Template> nestedTemplates;
    private volatile Template parent;
    private volatile RootSegment rootSegment;

    public Template(Long generatedId, String name, MustacheEngine engine) {
        this(generatedId, name, engine, null);
    }

    public Template(Long generatedId, String name, MustacheEngine engine, List<Template> nestedTemplates) {
        this(generatedId, name, engine, nestedTemplates, null);
    }

    private Template(Long generatedId, String name, MustacheEngine engine, List<Template> nestedTemplates, Template parent) {
        this.generatedId = generatedId;
        this.name = name;
        this.engine = engine;
        this.globalExecutionContext = ExecutionContexts.newGlobalExecutionContext(engine.getConfiguration());
        if (nestedTemplates == null || nestedTemplates.isEmpty()) {
            this.nestedTemplates = Collections.emptyMap();
        } else {
            ImmutableMap.ImmutableMapBuilder<String, Template> builder = ImmutableMap.builder();
            for (Template template : nestedTemplates) {
                builder.put(template.getName(), template);
            }
            this.nestedTemplates = builder.build();
        }
        this.parent = parent;
    }

    @Override
    public Long getGeneratedId() {
        return this.generatedId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String render(Object data) {
        StringBuilder builder = new StringBuilder();
        this.render(builder, data);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Appendable appendable, Object data) {
        DefaultMustacheRenderingEvent event = new DefaultMustacheRenderingEvent(this.engine.getConfiguration().getIdentifierGenerator().generate(MustacheRenderingEvent.class));
        try {
            this.renderingStarted(event);
            appendable = this.rootSegment.execute(appendable, data != null ? this.globalExecutionContext.setContextObject(data) : this.globalExecutionContext);
            RootSegment.flushAsyncAppendable(appendable);
            this.renderingFinished(event);
        }
        finally {
            event.release();
        }
    }

    public RootSegment getRootSegment() {
        return this.rootSegment;
    }

    synchronized void setRootSegment(RootSegment rootSegment) {
        if (this.rootSegment != null) {
            throw new MustacheException(MustacheProblem.TEMPLATE_MODIFICATION_NOT_ALLOWED);
        }
        this.rootSegment = rootSegment;
    }

    synchronized void setParent(Template parent) {
        if (this.parent != null) {
            throw new MustacheException(MustacheProblem.TEMPLATE_MODIFICATION_NOT_ALLOWED);
        }
        this.parent = parent;
    }

    public MustacheEngine getEngine() {
        return this.engine;
    }

    public Template getNestedTemplate(String name) {
        return this.parent != null ? this.parent.getNestedTemplate(name) : this.nestedTemplates.get(name);
    }

    private void renderingStarted(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners.isEmpty()) {
            return;
        }
        for (MustacheListener listener : listeners) {
            listener.renderingStarted(event);
        }
    }

    private void renderingFinished(MustacheRenderingEvent event) {
        List<MustacheListener> listeners = this.engine.getConfiguration().getMustacheListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ListIterator<MustacheListener> iterator = listeners.listIterator(listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().renderingFinished(event);
        }
    }

    public String toString() {
        return String.format("Template %s", this.name);
    }

    private class DefaultMustacheRenderingEvent
    extends AbstractReleaseCallbackContainer
    implements MustacheRenderingEvent {
        private final long id;

        public DefaultMustacheRenderingEvent(long id) {
            this.id = id;
        }

        @Override
        public String getMustacheName() {
            return Template.this.name;
        }

        @Override
        public long getMustacheGeneratedId() {
            return Template.this.generatedId;
        }

        @Override
        public Long getGeneratedId() {
            return this.id;
        }
    }
}

