/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Map;
import org.trimou.handlebars.AlternativesHelper;
import org.trimou.handlebars.AsyncHelper;
import org.trimou.handlebars.CacheHelper;
import org.trimou.handlebars.ChooseHelper;
import org.trimou.handlebars.EachHelper;
import org.trimou.handlebars.EmbedHelper;
import org.trimou.handlebars.EqualsHelper;
import org.trimou.handlebars.EvalHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.IfHelper;
import org.trimou.handlebars.IncludeHelper;
import org.trimou.handlebars.InvokeHelper;
import org.trimou.handlebars.IsHelper;
import org.trimou.handlebars.JoinHelper;
import org.trimou.handlebars.NullCheckHelper;
import org.trimou.handlebars.NumberIsEvenHelper;
import org.trimou.handlebars.NumberIsOddHelper;
import org.trimou.handlebars.NumericExpressionHelper;
import org.trimou.handlebars.RepeatHelper;
import org.trimou.handlebars.SetHelper;
import org.trimou.handlebars.SwitchHelper;
import org.trimou.handlebars.UnlessHelper;
import org.trimou.handlebars.WithHelper;
import org.trimou.util.ImmutableMap;

public final class HelpersBuilder {
    public static final String EACH = "each";
    public static final String IF = "if";
    public static final String UNLESS = "unless";
    public static final String WITH = "with";
    public static final String IS = "is";
    public static final String IS_EVEN = "isEven";
    public static final String IS_ODD = "isOdd";
    public static final String SET = "set";
    public static final String INCLUDE = "include";
    public static final String EMBED = "embed";
    public static final String IS_EQUAL = "isEq";
    public static final String IS_NOT_EQUAL = "isNotEq";
    public static final String IS_NULL = "isNull";
    public static final String IS_NOT_NULL = "isNotNull";
    public static final String CHOOSE = "choose";
    public static final String WHEN = "when";
    public static final String OTHERWISE = "otherwise";
    public static final String SWITCH = "switch";
    public static final String CASE = "case";
    public static final String DEFAULT = "default";
    public static final String JOIN = "join";
    public static final String EVAL = "eval";
    public static final String NUMERIC_EXPRESSION = "numExpr";
    public static final String ASYNC = "async";
    public static final String INVOKE = "invoke";
    public static final String ALT = "alt";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CACHE = "cache";
    public static final String REPEAT = "repeat";
    private final ImmutableMap.ImmutableMapBuilder<String, Helper> builder = ImmutableMap.builder();

    private HelpersBuilder() {
    }

    public HelpersBuilder add(String name, Helper helper) {
        this.builder.put(name, helper);
        return this;
    }

    public HelpersBuilder addEach() {
        this.builder.put(EACH, new EachHelper());
        return this;
    }

    public HelpersBuilder addIf() {
        this.builder.put(IF, new IfHelper());
        return this;
    }

    public HelpersBuilder addIf(String elseStartDelimiter, String elseEndDelimiter) {
        this.builder.put(IF, new IfHelper(elseStartDelimiter, elseEndDelimiter));
        return this;
    }

    public HelpersBuilder addUnless() {
        this.builder.put(UNLESS, new UnlessHelper());
        return this;
    }

    public HelpersBuilder addWith() {
        this.builder.put(WITH, new WithHelper());
        return this;
    }

    public HelpersBuilder addIs() {
        this.builder.put(IS, new IsHelper());
        return this;
    }

    public HelpersBuilder addIsEven() {
        this.builder.put(IS_EVEN, new NumberIsEvenHelper());
        return this;
    }

    public HelpersBuilder addIsOdd() {
        this.builder.put(IS_ODD, new NumberIsOddHelper());
        return this;
    }

    public HelpersBuilder addSet() {
        this.builder.put(SET, new SetHelper());
        return this;
    }

    public HelpersBuilder addInclude() {
        this.builder.put(INCLUDE, new IncludeHelper());
        return this;
    }

    public HelpersBuilder addEmbed() {
        this.builder.put(EMBED, new EmbedHelper());
        return this;
    }

    public HelpersBuilder addEmbed(EmbedHelper.SourceProcessor processor) {
        this.builder.put(EMBED, new EmbedHelper(processor));
        return this;
    }

    public HelpersBuilder addIsEqual() {
        this.builder.put(IS_EQUAL, new EqualsHelper());
        return this;
    }

    public HelpersBuilder addIsNotEqual() {
        this.builder.put(IS_NOT_EQUAL, new EqualsHelper(true));
        return this;
    }

    public HelpersBuilder addIsNull() {
        this.builder.put(IS_NULL, new NullCheckHelper());
        return this;
    }

    public HelpersBuilder addIsNotNull() {
        this.builder.put(IS_NOT_NULL, new NullCheckHelper(true));
        return this;
    }

    public HelpersBuilder addChoose() {
        this.builder.put(CHOOSE, new ChooseHelper());
        this.builder.put(WHEN, new ChooseHelper.WhenHelper());
        this.builder.put(OTHERWISE, new ChooseHelper.OtherwiseHelper());
        return this;
    }

    public HelpersBuilder addSwitch() {
        return this.addSwitch(false);
    }

    public HelpersBuilder addSwitch(boolean caseDefaultIsBreak) {
        this.builder.put(SWITCH, new SwitchHelper());
        this.builder.put(CASE, new SwitchHelper.CaseHelper(caseDefaultIsBreak));
        this.builder.put(DEFAULT, new SwitchHelper.DefaultHelper());
        return this;
    }

    public HelpersBuilder addJoin() {
        this.builder.put(JOIN, new JoinHelper());
        return this;
    }

    public HelpersBuilder addEval() {
        this.builder.put(EVAL, new EvalHelper());
        return this;
    }

    public HelpersBuilder addEval(EvalHelper.Notation notation) {
        this.builder.put(EVAL, new EvalHelper(notation));
        return this;
    }

    public HelpersBuilder addNumExpr() {
        this.builder.put(NUMERIC_EXPRESSION, new NumericExpressionHelper());
        return this;
    }

    public HelpersBuilder addNumExpr(NumericExpressionHelper.Operator defaultOperator) {
        this.builder.put(NUMERIC_EXPRESSION, new NumericExpressionHelper(defaultOperator));
        return this;
    }

    public HelpersBuilder addAsync() {
        this.builder.put(ASYNC, new AsyncHelper());
        return this;
    }

    public HelpersBuilder addInvoke() {
        this.builder.put(INVOKE, new InvokeHelper());
        return this;
    }

    public HelpersBuilder addAlt() {
        this.builder.put(ALT, new AlternativesHelper());
        return this;
    }

    public HelpersBuilder addAlt(AlternativesHelper.Selector selector) {
        this.builder.put(ALT, new AlternativesHelper(selector));
        return this;
    }

    public HelpersBuilder addMin() {
        this.builder.put(MIN, new AlternativesHelper(new AlternativesHelper.MinSelector()));
        return this;
    }

    public HelpersBuilder addMax() {
        this.builder.put(MAX, new AlternativesHelper(new AlternativesHelper.MaxSelector()));
        return this;
    }

    public HelpersBuilder addCache() {
        this.builder.put(CACHE, new CacheHelper());
        return this;
    }

    public HelpersBuilder addRepeat() {
        this.builder.put(REPEAT, new RepeatHelper());
        return this;
    }

    public HelpersBuilder addBuiltin() {
        this.addEach();
        this.addIf();
        this.addUnless();
        this.addWith();
        this.addIs();
        return this;
    }

    public HelpersBuilder addExtra() {
        this.addIsEven();
        this.addIsOdd();
        this.addSet();
        this.addInclude();
        this.addEmbed();
        this.addIsEqual();
        this.addIsNotEqual();
        this.addIsNull();
        this.addIsNotNull();
        this.addChoose();
        this.addSwitch();
        this.addJoin();
        this.addEval();
        this.addNumExpr();
        this.addAsync();
        this.addInvoke();
        this.addAlt();
        this.addMin();
        this.addMax();
        this.addCache();
        this.addRepeat();
        return this;
    }

    public Map<String, Helper> build() {
        return this.builder.build();
    }

    public static HelpersBuilder empty() {
        return new HelpersBuilder();
    }

    public static HelpersBuilder builtin() {
        return HelpersBuilder.empty().addBuiltin();
    }

    public static HelpersBuilder extra() {
        return HelpersBuilder.empty().addExtra();
    }

    public static HelpersBuilder all() {
        return HelpersBuilder.builtin().addExtra();
    }
}

