/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.HelperValidator;
import org.trimou.handlebars.Helpers;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableSet;

public class RepeatHelper
extends BasicSectionHelper {
    private final ConcurrentMap<String, String> whilePlaceholderKeys = new ConcurrentHashMap<String, String>();

    @Override
    public void execute(Options options) {
        block6: {
            block5: {
                Integer times = Helpers.initIntHashEntry(options, "times");
                if (times == null) break block5;
                for (int i = 0; i < times; ++i) {
                    options.fn();
                }
                break block6;
            }
            Object whileValue = options.getHash().get("while");
            if (whileValue == null) break block6;
            Object value = null;
            String whileExpr = (String)this.whilePlaceholderKeys.get(this.getKey(options));
            if (whileExpr != null) {
                value = whileValue;
            } else {
                whileExpr = whileValue.toString();
                value = options.getValue(whileExpr);
            }
            int limit = Helpers.initIntHashEntry(options, "limit", Integer.MAX_VALUE);
            int i = 0;
            while (!Checker.isFalsy(value)) {
                options.fn();
                if (i++ >= limit) {
                    throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, "Iteration limit exceeded", new Object[0]);
                }
                value = options.getValue(whileExpr);
            }
        }
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        if (definition.getHash().containsKey("times")) {
            Object times = definition.getHash().get("times");
            if (!Helpers.isValuePlaceholder(times) && !(times instanceof Integer)) {
                try {
                    Integer.valueOf(times.toString());
                }
                catch (NumberFormatException e) {
                    throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, (Throwable)e);
                }
            }
        } else if (definition.getHash().containsKey("while")) {
            Object whileExpr = definition.getHash().get("while");
            if (Helpers.isValuePlaceholder(whileExpr)) {
                this.whilePlaceholderKeys.put(this.getKey(definition), ((HelperDefinition.ValuePlaceholder)whileExpr).getName());
            }
        } else {
            throw HelperValidator.newValidationException("Either 'times' or 'while' hash entry is expected", RepeatHelper.class, definition);
        }
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    protected int numberOfRequiredHashEntries() {
        return 1;
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("times", "while", "limit");
    }

    private String getKey(HelperDefinition definition) {
        return definition.getTagInfo().getTemplateGeneratedId() + definition.getTagInfo().getId();
    }
}

