/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.ArchiveType;
import org.trimou.Mustache;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.AbstractTemplateLocator;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.lambda.SpecCompliantLambda;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;
import org.trimou.util.ImmutableSet;

public class MustacheEngineTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testGlobalData() {
        SpecCompliantLambda bold = new SpecCompliantLambda(){

            public String invoke(String text) {
                return "<b>" + text + "</b>";
            }

            public boolean isReturnValueInterpolated() {
                return false;
            }
        };
        SpecCompliantLambda italic = new SpecCompliantLambda(){

            public String invoke(String text) {
                return "<i>" + text + "</i>";
            }

            public boolean isReturnValueInterpolated() {
                return false;
            }
        };
        String templateContents = "{{foo}}| {{#bold}}Hello{{/bold}} {{#italic}}world{{/italic}}!|{{#archiveType.values}}{{this.suffix}}{{#iterHasNext}}, {{/iterHasNext}}{{/archiveType.values}}|{{archiveType.JAR}}";
        Mustache mustache = MustacheEngineBuilder.newBuilder().addGlobalData("foo", (Object)true).addGlobalData("archiveType", ArchiveType.class).addGlobalData("bold", (Object)bold).addGlobalData("italic", (Object)italic).build().compileMustache("global_data", templateContents);
        Assert.assertEquals((Object)"true| <b>Hello</b> <i>world</i>!|jar, war, ear|JAR", (Object)mustache.render(null));
    }

    @Test
    public void testDelimitersConfiguration() {
        Assert.assertEquals((Object)"bar", (Object)MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.START_DELIMITER, (Object)"<%").setProperty((ConfigurationKey)EngineConfigurationKey.END_DELIMITER, (Object)"//").build().compileMustache("delimiters_configuration", "<%foo//").render((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
    }

    @Test
    public void testDebugModeDisablesTemplateCache() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.DEBUG_MODE, (Object)true).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"foo", (Object)"Hey!"))).build();
        Assert.assertNotEquals((Object)engine.getMustache("foo"), (Object)engine.getMustache("foo"));
    }

    @Test
    public void testTemplateCacheExpirationTimeout() throws InterruptedException {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("foo", "0");
        long timeout = 1L;
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT, (Object)timeout).addTemplateLocator((TemplateLocator)new MapTemplateLocator(templates)).build();
        Assert.assertEquals((Object)"0", (Object)engine.getMustache("foo").render(null));
        templates.put("foo", "1");
        Assert.assertEquals((Object)"0", (Object)engine.getMustache("foo").render(null));
        Thread.sleep(2L * timeout * 1000L);
        Assert.assertEquals((Object)"1", (Object)engine.getMustache("foo").render(null));
    }

    @Test
    public void testTemplateCacheDisabled() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_CACHE_ENABLED, (Object)false).addTemplateLocator((TemplateLocator)new AbstractTemplateLocator(10){

            public Reader locate(String templateId) {
                return new StringReader(UUID.randomUUID().toString());
            }

            public Set<String> getAllIdentifiers() {
                return null;
            }
        }).build();
        int size = 10;
        HashSet<String> values = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            values.add(engine.getMustache("foo").render(null));
        }
        Assert.assertEquals((long)size, (long)values.size());
    }

    @Test
    public void testPrecompileAllAvailableTemplates() {
        final ArrayList sequence = new ArrayList();
        AbstractTemplateLocator locator01 = new AbstractTemplateLocator(10){

            public Reader locate(String templateId) {
                sequence.add("fooLocate");
                return templateId.equals("foo") ? new StringReader("{{foo}}") : null;
            }

            public Set<String> getAllIdentifiers() {
                sequence.add("fooGetAllIdentifiers");
                return ImmutableSet.of((Object[])new String[]{"foo"});
            }
        };
        MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES, (Object)true).addTemplateLocator((TemplateLocator)locator01).build();
        Assert.assertEquals((long)2L, (long)sequence.size());
        Assert.assertEquals((Object)"fooGetAllIdentifiers", sequence.get(0));
        Assert.assertEquals((Object)"fooLocate", sequence.get(1));
    }

    @Test
    public void testIterationMetadataAlias() {
        Assert.assertEquals((Object)"1", (Object)MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.ITERATION_METADATA_ALIAS, (Object)"foo").build().compileMustache("iter_meta_alias", "{{#this}}{{foo.index}}{{/this}}").render((Object)ImmutableList.of((Object[])new BigDecimal[]{BigDecimal.ZERO})));
    }

    @Test
    public void testTemplateLocatorReaderIsAlwaysClosed() {
        String template = "FOO";
        String illegalTemplate = "{{foo";
        final AtomicBoolean isCloseInvoked = new AtomicBoolean(false);
        AbstractTemplateLocator locator = new AbstractTemplateLocator(1){

            public Reader locate(String templateId) {
                return "foo".equals(templateId) ? new MyStringReader("FOO", isCloseInvoked) : new MyStringReader("{{foo", isCloseInvoked);
            }

            public Set<String> getAllIdentifiers() {
                return null;
            }
        };
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Assert.assertEquals((Object)"FOO", (Object)engine.getMustacheSource("foo"));
        Assert.assertTrue((boolean)isCloseInvoked.get());
        engine.invalidateTemplateCache();
        isCloseInvoked.set(false);
        Assert.assertFalse((boolean)isCloseInvoked.get());
        Assert.assertEquals((Object)"FOO", (Object)engine.getMustache("foo").render(null));
        Assert.assertTrue((boolean)isCloseInvoked.get());
        isCloseInvoked.set(false);
        Assert.assertFalse((boolean)isCloseInvoked.get());
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_INVALID_TEMPLATE, "Unexpected non-text buffer").check(() -> engine.getMustache("whatever").render(null));
        Assert.assertTrue((boolean)isCloseInvoked.get());
    }

    @Test
    public void testHelloWorld() {
        String data = "Hello world!";
        Assert.assertEquals((Object)data, (Object)MustacheEngineBuilder.newBuilder().build().compileMustache("myTemplateName", "{{this}}").render((Object)data));
    }

    @Test
    public void testGeneratedIdsAreUnique() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().build();
        Assert.assertNotEquals((Object)engine.compileMustache("foo", "{{foo}}").getGeneratedId(), (Object)engine.compileMustache("foo", "{{foo}}").getGeneratedId());
    }

    @Test
    public void testInvalidateTemplateCache() {
        AtomicInteger locatorCalled = new AtomicInteger(0);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator(name -> {
            locatorCalled.incrementAndGet();
            return new StringReader("{{this}}");
        }).build();
        Assert.assertEquals((Object)"foo", (Object)engine.getMustache("any").render((Object)"foo"));
        Assert.assertEquals((Object)"bar", (Object)engine.getMustache("one").render((Object)"bar"));
        Assert.assertEquals((long)2L, (long)locatorCalled.get());
        engine.invalidateTemplateCache(name -> name.equals("any"));
        Assert.assertEquals((Object)"foo", (Object)engine.getMustache("any").render((Object)"foo"));
        Assert.assertEquals((long)3L, (long)locatorCalled.get());
    }

    @Test
    public void testTemplateCacheUsedForSource() {
        AtomicInteger locatorCalled = new AtomicInteger(0);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator(name -> {
            locatorCalled.incrementAndGet();
            return new StringReader("{{this}}");
        }).build();
        Assert.assertEquals((Object)"{{this}}", (Object)engine.getMustacheSource("any"));
        Assert.assertEquals((Object)"{{this}}", (Object)engine.getMustacheSource("any"));
        Assert.assertEquals((long)2L, (long)locatorCalled.get());
        locatorCalled.set(0);
        engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_CACHE_USED_FOR_SOURCE, (Object)true).addTemplateLocator(name -> {
            locatorCalled.incrementAndGet();
            return new StringReader("{{this}}");
        }).build();
        Assert.assertEquals((Object)"{{this}}", (Object)engine.getMustacheSource("any"));
        Assert.assertEquals((Object)"{{this}}", (Object)engine.getMustacheSource("any"));
        Assert.assertEquals((long)1L, (long)locatorCalled.get());
    }

    private static class MyStringReader
    extends StringReader {
        final AtomicBoolean isCloseInvoked;

        public MyStringReader(String s, AtomicBoolean isClosed) {
            super(s);
            this.isCloseInvoked = isClosed;
        }

        @Override
        public void close() {
            this.isCloseInvoked.set(true);
            super.close();
        }
    }
}

