/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.util.ImmutableSet;

public class InitPropertiesTest
extends AbstractEngineTest {
    private final ConfigurationKey testResolverKeyAlpha = new SimpleConfigurationKey("test.key.alpha", (Object)true);
    private final ConfigurationKey testResolverKeyBravo = new SimpleConfigurationKey("test.key.bravo", (Object)1L);

    @Override
    @Before
    public void buildEngine() {
        System.setProperty(EngineConfigurationKey.CACHE_SECTION_LITERAL_BLOCK.get(), "true");
        System.setProperty(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY.get(), "2000");
        System.setProperty("test.key.bravo", "1000");
        this.engine = MustacheEngineBuilder.newBuilder().setProperty(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY, (Object)"3000").addResolver((Resolver)new AbstractResolver(0){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                return null;
            }

            public Set<ConfigurationKey> getConfigurationKeys() {
                return ImmutableSet.of((Object[])new ConfigurationKey[]{InitPropertiesTest.this.testResolverKeyAlpha, InitPropertiesTest.this.testResolverKeyBravo});
            }
        }).build();
    }

    @After
    public void resetSystemProperties() {
        System.setProperty(EngineConfigurationKey.CACHE_SECTION_LITERAL_BLOCK.get(), EngineConfigurationKey.CACHE_SECTION_LITERAL_BLOCK.getDefaultValue().toString());
        System.setProperty(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY.get(), ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY.getDefaultValue().toString());
    }

    @Test
    public void testInitializeProperties() {
        Assert.assertEquals((Object)EngineConfigurationKey.START_DELIMITER.getDefaultValue(), (Object)this.engine.getConfiguration().getStringPropertyValue((ConfigurationKey)EngineConfigurationKey.START_DELIMITER));
        Assert.assertEquals((Object)EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES.getDefaultValue(), (Object)this.engine.getConfiguration().getBooleanPropertyValue((ConfigurationKey)EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES));
        Assert.assertTrue((boolean)this.engine.getConfiguration().getBooleanPropertyValue((ConfigurationKey)EngineConfigurationKey.CACHE_SECTION_LITERAL_BLOCK));
        Assert.assertFalse((boolean)this.engine.getConfiguration().getBooleanPropertyValue(this.testResolverKeyAlpha));
        Assert.assertEquals((Object)3000L, (Object)this.engine.getConfiguration().getLongPropertyValue(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY));
        Assert.assertEquals((Object)1000L, (Object)this.engine.getConfiguration().getLongPropertyValue(this.testResolverKeyBravo));
    }
}

