/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.engine.convert.ObjectToDateConverter;

public class ObjectToDateConverterTest {
    @Test
    public void testConverter() {
        String pattern = "yyyy.MM.dd HH:mm:ss.SSS";
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        ObjectToDateConverter converter = new ObjectToDateConverter(pattern);
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        Calendar midnight = Calendar.getInstance();
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        midnight.set(14, 0);
        LocalDateTime dateTime = LocalDateTime.ofInstant(now.toInstant(), ZoneId.systemDefault());
        LocalDate date = LocalDateTime.ofInstant(midnight.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Assert.assertNull((Object)converter.convert((Object)BigDecimal.ONE));
        Assert.assertEquals((Object)now, (Object)converter.convert((Object)now));
        Assert.assertEquals((Object)now, (Object)converter.convert((Object)now.getTime()));
        Assert.assertEquals((Object)cal.getTime(), (Object)converter.convert((Object)cal));
        Assert.assertEquals((Object)now, (Object)converter.convert((Object)format.format(now)));
        Assert.assertEquals((Object)now, (Object)converter.convert((Object)dateTime));
        Assert.assertEquals((Object)midnight.getTime(), (Object)converter.convert((Object)date));
    }
}

