/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.convert.ValueConverter;

public class ValueConverterTest
extends AbstractTest {
    @Test
    public void testValueConverter() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addValueConverter(v -> v.toString().toUpperCase()).build();
        Assert.assertEquals((Object)"FOO", (Object)engine.compileMustache("value_converter", "{{this}}").render((Object)"Foo"));
    }

    @Test
    public void testInvalidValueConverter() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addValueConverter(new ValueConverter(){

            public String convert(Object from) {
                return from.toString().toUpperCase();
            }

            public boolean isValid() {
                return false;
            }
        }).build();
        Assert.assertEquals((Object)"Foo", (Object)engine.compileMustache("value_converter_invalid", "{{this}}").render((Object)"Foo"));
    }

    @Test
    public void testValueConverterOrdering() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addValueConverter(new ValueConverter(){

            public String convert(Object from) {
                return from.toString().toUpperCase();
            }

            public int getPriority() {
                return 1;
            }
        }).addValueConverter(new ValueConverter(){

            public String convert(Object from) {
                return from.toString().toLowerCase();
            }

            public int getPriority() {
                return 2;
            }
        }).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("value_converter_ordering", "{{this}}").render((Object)"Foo"));
    }
}

