/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.ExceptionAssert;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.FileSystemTemplateLocator;
import org.trimou.engine.locator.PathTemplateLocator;
import org.trimou.engine.locator.PathTemplateLocatorTest;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;

public class FileSystemTemplateLocatorTest
extends PathTemplateLocatorTest {
    @Test
    public void testLocator() throws IOException {
        FileSystemTemplateLocator locator = new FileSystemTemplateLocator(1, "src/test/resources/locator/file", "foo");
        MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Set ids = locator.getAllIdentifiers();
        Assert.assertEquals((long)5L, (long)ids.size());
        Assert.assertTrue((boolean)ids.contains("index"));
        Assert.assertTrue((boolean)ids.contains("home"));
        Assert.assertTrue((boolean)ids.contains("foo"));
        Assert.assertTrue((boolean)ids.contains("sub/bar"));
        Assert.assertTrue((boolean)ids.contains("sub/subsub/qux"));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("index")));
        Assert.assertEquals((Object)"bar", (Object)this.read(locator.locate("home")));
        Assert.assertEquals((Object)"foo", (Object)this.read(locator.locate("foo")));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("sub/bar")));
        Assert.assertEquals((Object)"{{bar}}", (Object)this.read(locator.locate("sub/subsub/qux")));
    }

    @Test
    public void testLocatorNoSuffix() throws IOException {
        FileSystemTemplateLocator locator = FileSystemTemplateLocator.builder().setRootPath("src/test/resources/locator/file").build();
        MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Set ids = locator.getAllIdentifiers();
        Assert.assertEquals((long)7L, (long)ids.size());
        Assert.assertTrue((boolean)ids.contains("index.foo"));
        Assert.assertTrue((boolean)ids.contains("home.foo"));
        Assert.assertTrue((boolean)ids.contains("foo.foo"));
        Assert.assertTrue((boolean)ids.contains("detail.html"));
        Assert.assertTrue((boolean)ids.contains("encoding.html"));
        Assert.assertTrue((boolean)ids.contains("sub/bar.foo"));
        Assert.assertTrue((boolean)ids.contains("sub/subsub/qux.foo"));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("index.foo")));
        Assert.assertEquals((Object)"bar", (Object)this.read(locator.locate("home.foo")));
        Assert.assertEquals((Object)"foo", (Object)this.read(locator.locate("foo.foo")));
        Assert.assertEquals((Object)"<html/>", (Object)this.read(locator.locate("detail.html")));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("sub/bar.foo")));
        Assert.assertEquals((Object)"{{bar}}", (Object)this.read(locator.locate("sub/subsub/qux.foo")));
    }

    @Test
    public void testInvalidRootDir() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION).check(() -> new FileSystemTemplateLocator(1, "_?dsss"));
        ExceptionAssert.expect(IllegalArgumentException.class).check(() -> new FileSystemTemplateLocator(1, null));
    }

    @Test
    public void testCustomVirtualPathSeparator() throws IOException {
        FileSystemTemplateLocator locator = FileSystemTemplateLocator.builder().setPriority(1).setRootPath("src/test/resources/locator/file").setSuffix("foo").build();
        MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty(PathTemplateLocator.VIRTUAL_PATH_SEPARATOR_KEY, (Object)"*").build();
        Set names = locator.getAllIdentifiers();
        Assert.assertEquals((long)5L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("index"));
        Assert.assertTrue((boolean)names.contains("home"));
        Assert.assertTrue((boolean)names.contains("foo"));
        Assert.assertTrue((boolean)names.contains("sub*bar"));
        Assert.assertTrue((boolean)names.contains("sub*subsub*qux"));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("index")));
        Assert.assertEquals((Object)"bar", (Object)this.read(locator.locate("home")));
        Assert.assertEquals((Object)"{{foo}}", (Object)this.read(locator.locate("sub*bar")));
        Assert.assertEquals((Object)"{{bar}}", (Object)this.read(locator.locate("sub*subsub*qux")));
    }

    @Test
    public void testEncoding() throws IOException {
        FileSystemTemplateLocator locator = new FileSystemTemplateLocator(1, "src/test/resources/locator/file", "html");
        MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.DEFAULT_FILE_ENCODING, (Object)"windows-1250").addTemplateLocator((TemplateLocator)locator).build();
        Assert.assertEquals((Object)"Hur\u00e1 \u011b\u0161\u010d\u0159\u0159\u017e\u017e\u00fd\u00e1!", (Object)this.read(locator.locate("encoding")));
    }
}

