/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ValidationTest
extends AbstractEngineTest {
    @Test
    public void testTagContentValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED, (Object)false).build();
        this.testInvalidTemplate(engine, "{{fo{{o}}", MustacheProblem.COMPILE_INVALID_TAG, "tag_contains_start_delimiter");
        this.testInvalidTemplate(engine, "{{foo}} {{ boo {{bar}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        this.testInvalidTemplate(engine, "{{foo and me}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        this.testInvalidTemplate(engine, "{{#fo\no}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        this.testInvalidTemplate(engine, "{{>fo .txt}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("engine", "{{! Hello there my friends}}").render(null));
        this.testInvalidTemplate(engine, "Hello\n\n\n{{}}", MustacheProblem.COMPILE_INVALID_TAG, "invalid_tag01");
        engine = MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED, (Object)true).build();
        this.testInvalidTemplate(engine, "{{foo}} {{ boo {{bar}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        this.testValidTemplate(engine, "{{foo and me}}");
        this.testInvalidTemplate(engine, "{{#fo\no}}", MustacheProblem.COMPILE_INVALID_TEMPLATE, "not_a_nonwhitespace_character_sequence");
        this.testInvalidTemplate(engine, "{{>fo .txt}}", MustacheProblem.COMPILE_INVALID_TAG, "not_a_nonwhitespace_character_sequence");
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("engine", "{{! Hello there my friends}}").render(null));
        this.testInvalidTemplate(engine, "Hello\n\n\n{{}}", MustacheProblem.COMPILE_INVALID_TAG, "invalid_tag01");
    }

    @Test
    public void testInvalidDelimiters() {
        this.testInvalidTemplate(this.engine, "{{==}}", MustacheProblem.COMPILE_INVALID_DELIMITERS, "invalid_delimiters01");
        this.testInvalidTemplate(this.engine, "{{=%% %%}}", MustacheProblem.COMPILE_INVALID_DELIMITERS, "invalid_delimiters02");
        this.testInvalidTemplate(this.engine, "{{= %}}", MustacheProblem.COMPILE_INVALID_DELIMITERS, "invalid_delimiters03");
        this.testInvalidTemplate(this.engine, "{{= =}}", MustacheProblem.COMPILE_INVALID_DELIMITERS, "invalid_delimiters04");
    }

    @Test
    public void testInvalidSectionEnds() {
        this.testInvalidTemplate(this.engine, "Hello {{#foo}} and...", MustacheProblem.COMPILE_INVALID_TEMPLATE, "no_section_end");
        this.testInvalidTemplate(this.engine, "Hello {{#foo}} and... {{/foo}}{{/bar}}", MustacheProblem.COMPILE_INVALID_SECTION_END, "invalid_section_end01");
        this.testInvalidTemplate(this.engine, "Hello {{/foo}}", MustacheProblem.COMPILE_INVALID_SECTION_END, "invalid_section_end02");
        this.testInvalidTemplate(this.engine, "Hello,\n{{^foo}}{{/bar}}", MustacheProblem.COMPILE_INVALID_SECTION_END, "invalid_section_end03");
    }

    @Test
    public void testIncompleteTag() {
        this.testInvalidTemplate(this.engine, "{{ foo", MustacheProblem.COMPILE_INVALID_TEMPLATE, "incomplete_tag");
    }

    private void testInvalidTemplate(MustacheEngine engine, String template, MustacheProblem expectedProblem, String description) {
        try {
            engine.compileMustache("validation_" + description, template);
            Assert.fail((String)("Problem expected: " + expectedProblem));
        }
        catch (MustacheException e) {
            if (!expectedProblem.equals((Object)e.getCode())) {
                Assert.fail((String)("Invalid problem: " + e.getMessage()));
            }
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Incorrect exception: " + e));
        }
    }

    private void testValidTemplate(MustacheEngine engine, String template) {
        engine.compileMustache("validation", template);
    }
}

