/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;

public class HelperExecutionHandlerTest {
    @Test
    public void testSplitHelperName() {
        this.assertHelperNameParts("name foo.bar", "name", "foo.bar");
        this.assertHelperNameParts("name  hash1=\"DD-MM-yyyy HH:mm\"", "name", "hash1=\"DD-MM-yyyy HH:mm\"");
        this.assertHelperNameParts("name key='value'", "name", "key='value'");
        this.assertHelperNameParts("name key=''value''", "name", "key=''value''");
        this.assertHelperNameParts("key='value foo=' 'bar'", "key='value foo='", "'bar'");
        this.assertHelperNameParts("'key'='value foo=' 'bar'", "'key'='value foo='", "'bar'");
        this.assertHelperNameParts("foo='bar = \n baz' qux", "foo='bar = \n baz'", "qux");
        this.assertHelperNameParts("[ 'foo', 'bar', qux] foo", "[ 'foo', 'bar', qux]", "foo");
        this.assertHelperNameParts("1 20 ['', '1'] foo", "1", "20", "['', '1']", "foo");
        this.assertHelperNameParts("'[1, 2]'", "'[1, 2]'");
        this.assertHelperNameParts("'[1, '2', 'alpha']'", "'[1, '2', 'alpha']'");
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> this.assertHelperNameParts("name key=''value'", new String[0])).check(() -> this.assertHelperNameParts("name key=value'", new String[0])).check(() -> this.assertHelperNameParts("name key='value foo", new String[0])).check(() -> this.assertHelperNameParts("name key=value' foo", new String[0])).check(() -> this.assertHelperNameParts("'name key=value", new String[0])).check(() -> this.assertHelperNameParts("key=\"value \" and\"", new String[0]));
    }

    @Test
    public void testGetFirstDeterminingEqualsCharPosition() {
        Assert.assertEquals((long)3L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"foo=bar"));
        Assert.assertEquals((long)3L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"foo='bar='"));
        Assert.assertEquals((long)1L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"1='bar='"));
        Assert.assertEquals((long)-1L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"'m=n'"));
        Assert.assertEquals((long)-1L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)" ' m=n'"));
        Assert.assertEquals((long)-1L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"'1'"));
        Assert.assertEquals((long)-1L, (long)HelperExecutionHandler.getFirstDeterminingEqualsCharPosition((String)"\"foo\""));
    }

    private void assertHelperNameParts(String name, String ... parts) {
        ArrayList result = new ArrayList();
        Iterator iterator = HelperExecutionHandler.splitHelperName((String)name, null);
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        ArrayList<String> expected = new ArrayList<String>();
        for (String part : parts) {
            expected.add(part);
        }
        Assert.assertTrue((String)("Parts: " + expected + " != " + result), (expected.containsAll(result) && result.containsAll(expected) ? 1 : 0) != 0);
    }
}

