/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Template;

public class LineSeparatorSegmentTest
extends AbstractEngineTest {
    @Override
    public void buildEngine() {
    }

    @Test
    public void testLineSeparators() {
        String templateContents = "\nHello\r\n\n!";
        Mustache mustache = MustacheEngineBuilder.newBuilder().build().compileMustache("line_sep", templateContents);
        Assert.assertEquals((Object)"\nHello\r\n\n!", (Object)mustache.render(null));
    }

    @Test
    public void testLineSeparatorsReuse() {
        Template template = (Template)MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.REUSE_LINE_SEPARATOR_SEGMENTS, (Object)true).build().compileMustache("line_sep_reuse_enabled", "Hello\n\n\n");
        Assert.assertEquals((long)4L, (long)template.getRootSegment().getSegmentsSize(false));
        Assert.assertEquals(template.getRootSegment().getSegments().get(1), template.getRootSegment().getSegments().get(2));
        Assert.assertEquals(template.getRootSegment().getSegments().get(1), template.getRootSegment().getSegments().get(3));
    }

    @Test
    public void testLineSeparatorsReuseDisabled() {
        Template template = (Template)MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.REUSE_LINE_SEPARATOR_SEGMENTS, (Object)false).build().compileMustache("line_sep_reuse_disabled", "Hello\n\n\n");
        Assert.assertEquals((long)4L, (long)template.getRootSegment().getSegmentsSize(false));
        Assert.assertNotEquals(template.getRootSegment().getSegments().get(1), template.getRootSegment().getSegments().get(2));
        Assert.assertNotEquals(template.getRootSegment().getSegments().get(1), template.getRootSegment().getSegments().get(3));
    }
}

