/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableMap;

public class AsyncHelperTest
extends AbstractTest {
    @Test
    public void testAsyncHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setExecutorService(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors())).registerHelpers(HelpersBuilder.empty().addAsync().addInclude().build()).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)"async"))).build();
        Assert.assertEquals((Object)"Hello async world!!", (Object)engine.compileMustache("async_helper01", "Hello {{#async}}{{include templateName}} {{world}}{{/async}}!").render((Object)ImmutableMap.of((Object)"templateName", (Object)"template", (Object)"world", (Object)"world!")));
    }

    @Test
    public void testAsyncHelperNested() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setExecutorService(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors())).registerHelpers(HelpersBuilder.empty().addAsync().addInclude().build()).addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"template", (Object)"async"))).build();
        Assert.assertEquals((Object)"Hello async world! No!", (Object)engine.compileMustache("async_helper02", "Hello {{#async}}{{include templateName}} {{#async}}{{#async}}{{world}}{{/async}}{{/async}}{{#async}}!{{/async}}{{/async}}{{#async}} No{{/async}}!").render((Object)ImmutableMap.of((Object)"templateName", (Object)"template", (Object)"world", (Object)"world")));
    }

    @Test
    public void testAsyncHelperNeedsExecutorService() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addAsync().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_ASYNC_PROCESSING_ERROR).check(() -> engine.compileMustache("async_helper03", "{{#async}}foo{{/async}}").render(null));
    }
}

