/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.AssertUtil;
import org.trimou.DummyHelper;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.Function;
import org.trimou.handlebars.Functions;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;
import org.trimou.util.ImmutableSet;

public class BuiltInHelpersTest
extends AbstractEngineTest {
    @Test
    public void testEachHelper() {
        Assert.assertEquals((Object)"foo,bar", (Object)this.engine.compileMustache("each_helper1", "{{#each this}}{{this}}{{#iterHasNext}},{{/iterHasNext}}{{/each}}").render((Object)new Object[]{"foo", "bar"}));
        Assert.assertEquals((Object)"foo,bar", (Object)this.engine.compileMustache("each_helper2", "{{#each this}}{{this}}{{#iterHasNext}},{{/iterHasNext}}{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar"})));
        Assert.assertEquals((Object)"foo,baz", (Object)this.engine.compileMustache("each_helper3", "{{#each data apply=myFilter}}{{this}}{{#if iter.hasNext}},{{/if}}{{/each}}").render((Object)ImmutableMap.of((Object)"myFilter", (Object)Functions.from(input -> input.toString().equals("bar") ? "org.trimou.handlebars.skipResult" : input), (Object)"data", (Object)ImmutableSet.of((Object[])new String[]{"foo", "bar", "baz"}))));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("each_helper4", "{{#each data apply=myFilter}}{{this}}{{/each}}").render((Object)ImmutableMap.of((Object)"myFilter", (Object)new Function(){

            public Object apply(Object value) {
                return "org.trimou.handlebars.skipResult";
            }
        }, (Object)"data", (Object)ImmutableSet.of((Object[])new String[]{"foo", "bar", "baz"}))));
        Assert.assertEquals((Object)"332", (Object)this.engine.compileMustache("each_helper5", "{{#each data apply=toLength}}{{this}}{{/each}}").render((Object)ImmutableMap.of((Object)"toLength", (Object)new Function(){

            public Object apply(Object value) {
                return value.toString().length();
            }
        }, (Object)"data", (Object)ImmutableList.of((Object[])new String[]{"foo", "bar", "ba"}))));
        Assert.assertEquals((Object)"332", (Object)this.engine.compileMustache("each_helper6", "{{#each this as='item'}}{{item.length}}{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar", "ba"})));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("each_helper7", "{{#each this}}foo{{/each}}").render(null));
        Assert.assertEquals((Object)"1:foo,2:bar,3:baz", (Object)this.engine.compileMustache("each_helper8", "{{#each list1 list2 list3}}{{index}}:{{this}}{{#if hasNext}},{{/if}}{{/each}}").render((Object)ImmutableMap.of((Object)"list1", (Object)ImmutableList.of((Object[])new String[]{"foo", "bar"}), (Object)"list2", (Object)ImmutableList.of((Object[])new String[]{"baz"}))));
        Assert.assertEquals((Object)"1foo2bar", (Object)this.engine.compileMustache("each_helper9", "{{#each this}}{{index}}{{.}}{{/each}}").render((Object)new Object[]{"foo", "bar"}));
        String result = this.engine.compileMustache("each_helper10", "{{#each this.entrySet}}{{key}}:{{value}}{{/each}}").render((Object)ImmutableMap.of((Object)"foo", (Object)1, (Object)"bar", (Object)2));
        Assert.assertTrue((boolean)result.contains("foo:1"));
        Assert.assertTrue((boolean)result.contains("bar:2"));
        Assert.assertEquals((Object)"1,20,hello,pixie", (Object)this.engine.compileMustache("each_helper10", "{{#each [1,20,'hello', this]}}{{.}}{{#if hasNext}},{{/if}}{{/each}}").render((Object)"pixie"));
        Assert.assertEquals((Object)"1,20,hello,pixie", (Object)this.engine.compileMustache("each_helper11", "{{#each [1,20] ['hello', this]}}{{.}}{{#if hasNext}},{{/if}}{{/each}}").render((Object)"pixie"));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("each_helper_empty_array", "{{#each this}}foo{{/each}}").render((Object)new String[0]));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("each_helper_empty_collection", "{{#each this}}foo{{/each}}").render(new ArrayList()));
        AssertUtil.assertCompilationFails(this.engine, "each_helper_fail1", "{{#each}}{{this}}{{/each}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        AssertUtil.assertCompilationFails(this.engine, "each_helper_fail2", "{{each}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(() -> this.engine.compileMustache("each_helper_filter_fail1", "{{#each data apply=foo}}{{/each}}").render((Object)ImmutableMap.of((Object)"data", (Object)new Object[]{"foo"}, (Object)"foo", (Object)Boolean.FALSE)));
    }

    @Test
    public void testIfHelper() {
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("if_helper1", "{{#if this}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("if_helper2", "{{#if this}}hello{{/if}}").render((Object)false));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("if_helper3", "{{#if this this}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("if_helper4", "{{#if this \"\"}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("if_helper5", "{{#if this \"true\" this}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("if_helper6", "{{#if this \"\" logic=\"or\"}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"false", (Object)this.engine.compileMustache("if_helper7", "{{#if this \"\" logic=\"and\" else='false'}}hello{{/if}}").render((Object)Boolean.TRUE));
        Assert.assertEquals((Object)"Hello me! false", (Object)this.engine.compileMustache("if_helper8", "{{#if this.0 else='{this.1} me! {this.0}'}}hello{{/if}}").render((Object)new Object[]{Boolean.FALSE, "Hello"}));
        AssertUtil.assertCompilationFails(this.engine, "if_helper_fail1", "{{#if}}{{this}}{{/if}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        AssertUtil.assertCompilationFails(this.engine, "if_helper_fail2", "{{if}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }

    @Test
    public void testIfHelperCustomElseDelimiters() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIf("$$", "$$").build(), true).build();
        Assert.assertEquals((Object)"Length: 5", (Object)engine.compileMustache("if_helper_custom_else", "{{#if this else='Length: $$this.toString.length$$'}}hello{{/if}}").render((Object)Boolean.FALSE));
    }

    @Test
    public void testUnlessHelper() {
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("unless_helper1", "{{#unless this}}hello{{/unless}}").render((Object)Boolean.FALSE));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("unless_helper2", "{{#unless this}}hello{{/unless}}").render((Object)true));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("unless_helper3", "{{#unless this this}}hello{{/unless}}").render((Object)true));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("unless_helper4", "{{#unless this \"\"}}hello{{/unless}}").render((Object)true));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("unless_helper5", "{{#unless this \"\" logic=\"and\"}}hello{{/unless}}").render((Object)true));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("unless_helper6", "{{#unless this}}hello{{/unless}}").render((Object)new BigDecimal("0.1")));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("unless_helper6", "{{#unless this}}hello{{/unless}}").render((Object)new BigDecimal("0.000")));
        Assert.assertEquals((Object)"7", (Object)this.engine.compileMustache("unless_helper7", "{{#unless this else='{this.length}'}}hello{{/unless}}").render((Object)"matched"));
        AssertUtil.assertCompilationFails(this.engine, "unless_helper_fail1", "{{#unless}}{{this}}{{/unless}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        AssertUtil.assertCompilationFails(this.engine, "unless_helper_fail2", "{{unless}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }

    @Test
    public void testWithHelper() {
        Assert.assertEquals((Object)"10", (Object)this.engine.compileMustache("with_helper1", "{{#with this}}{{age}}{{/with}}").render((Object)new Hammer()));
        AssertUtil.assertCompilationFails(this.engine, "with_helper_fail1", "{{#with}}{{this}}{{/with}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        AssertUtil.assertCompilationFails(this.engine, "with_helper_fail2", "{{with}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
        Assert.assertEquals((Object)"10", (Object)this.engine.compileMustache("with_helper_nested", "{{#with this}}{{#with age}}{{intValue}}{{/with}}{{/with}}").render((Object)new Hammer()));
    }

    @Test
    public void testIsHelper() {
        Assert.assertEquals((Object)"bye", (Object)this.engine.compileMustache("is_helper1", "{{is this \"hello\" \"bye\"}}").render((Object)false));
        Assert.assertEquals((Object)"", (Object)this.engine.compileMustache("is_helper2", "{{is this \"hello\"}}").render((Object)false));
        Assert.assertEquals((Object)"hello", (Object)this.engine.compileMustache("is_helper3", "{{is this \"hello\"}}").render((Object)true));
        Assert.assertEquals((Object)"&lt;html&gt;", (Object)this.engine.compileMustache("is_helper4", "{{is this \"<html>\"}}").render((Object)true));
        Assert.assertEquals((Object)"<html>", (Object)this.engine.compileMustache("is_helper5", "{{{is this \"<html>\"}}}").render((Object)true));
    }

    @Test
    public void testOverwriteHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("each", (Helper)new DummyHelper(), true).registerHelpers(HelpersBuilder.empty().add("if", (Helper)new DummyHelper()).build(), true).build();
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("helper_dummy1", "{{#each this}}EACH{{/each}}{{#if this}}IF{{/if}}").render((Object)new String[]{"hey"}));
    }
}

