/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class FormatHelperTest
extends AbstractTest {
    @Test
    public void testInterpolation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addFmt().build()).build();
        Assert.assertEquals((Object)"Hello me!", (Object)engine.compileMustache("fmt_helper01", "{{fmt 'Hello %s!' 'me'}}").render(null));
        Assert.assertEquals((Object)" d  c  b  a", (Object)engine.compileMustache("fmt_helper02", "{{fmt '%4$2s %3$2s %2$2s %1$2s' 'a' 'b' 'c' 'd'}}").render(null));
        Assert.assertEquals((Object)"Tuesday", (Object)engine.compileMustache("fmt_helper03", "{{fmt '%tA' this locale='en'}}").render((Object)LocalDateTime.of(2016, 7, 26, 12, 0)));
    }

    @Test
    public void testValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addFmt().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("fmt_helper_validation01", "{{#fmt}}{{/fmt}}")).check(() -> engine.compileMustache("fmt_helper_validation02", "{{fmt}}"));
    }
}

