/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.lambda.InputLiteralLambda;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;

public class JoinHelperTest
extends AbstractTest {
    @Test
    public void testJoinHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addJoin().build()).addGlobalData("li", (Object)new InputLiteralLambda(){

            public boolean isReturnValueInterpolated() {
                return false;
            }

            public String invoke(String text) {
                return "<li>" + text + "</li>";
            }
        }).build();
        String[] array = new String[]{"alpha", "bravo", "charlie"};
        List list = ImmutableList.of((Object[])new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((Object)"alphabravocharliefoo", (Object)engine.compileMustache("join_helper1", "{{join this 'foo' nullValue}}").render((Object)array));
        Assert.assertEquals((Object)"alpha : bravo : charlie", (Object)engine.compileMustache("join_helper2", "{{join this delimiter=' : '}}").render((Object)array));
        Assert.assertEquals((Object)"foo,bar,baz,alpha,bravo,charlie", (Object)engine.compileMustache("join_helper3", "{{join list array delimiter=','}}").render((Object)ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list)));
        Assert.assertEquals((Object)"start,foo,bar,baz,middle,alpha,bravo,charlie,end", (Object)engine.compileMustache("join_helper4", "{{join 'start' list 'middle' array 'end' delimiter=','}}").render((Object)ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list)));
        Assert.assertEquals((Object)"<start><end>", (Object)engine.compileMustache("join_helper5", "{{&join '<start>' '<end>'}}").render((Object)ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list)));
        Assert.assertEquals((Object)"&lt;start&gt;&lt;end&gt;", (Object)engine.compileMustache("join_helper6", "{{join '<start>' '<end>'}}").render((Object)ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list)));
        Assert.assertEquals((Object)"<li>foo</li>\n<li>bar</li>\n<li>baz</li>\n<li>Me</li>\n<li>alpha</li>\n<li>bravo</li>\n<li>charlie</li>", (Object)engine.compileMustache("join_helper7", "{{&join list 'Me' array delimiter='\n' lambda=li foo='baz'}}").render((Object)ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list)));
    }

    @Test
    public void testJoinHelperValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addJoin().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("join_helper_validation01", "{{join}}"));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(() -> engine.compileMustache("join_helper_validation02", "{{join 'Me' lambda='foo'}}").render(null));
    }
}

