/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locale.FixedLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.i18n.TimeFormatHelper;
import org.trimou.util.ImmutableMap;
import org.trimou.util.Strings;

public class TimeFormatHelperTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
        this.engine = MustacheEngineBuilder.newBuilder().registerHelper("formatTime", (Helper)new TimeFormatHelper()).setLocaleSupport((LocaleSupport)FixedLocaleSupport.from((Locale)Locale.ENGLISH)).build();
    }

    @Test
    public void testInterpolation() {
        Calendar day = this.day();
        day.set(1, 2013);
        day.set(2, 0);
        day.set(5, 1);
        day.set(11, 13);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        long milis = day.getTimeInMillis();
        String expectedShort = "1/1/13 1:00 PM";
        String expectedMedium = "Jan 1, 2013 1:00:00 PM";
        String expectedCustom = "01-01-2013 13:00";
        Map data = ImmutableMap.of((Object)"calendar", (Object)day, (Object)"date", (Object)day.getTime(), (Object)"milis", (Object)milis, (Object)"localDateTime", (Object)LocalDateTime.ofInstant(day.toInstant(), TimeZone.getDefault().toZoneId()));
        Assert.assertEquals((Object)Strings.repeat((String)expectedMedium, (int)4, (String)"|"), (Object)this.engine.compileMustache("time_helper_medium", "{{formatTime calendar style=\"medium\"}}|{{formatTime date style=\"medium\"}}|{{formatTime milis style=\"medium\"}}|{{formatTime localDateTime style=\"medium\"}}").render((Object)data));
        Assert.assertEquals((Object)Strings.repeat((String)expectedShort, (int)4, (String)"|"), (Object)this.engine.compileMustache("time_helper_short", "{{formatTime calendar style=\"short\"}}|{{formatTime date style=\"short\"}}|{{formatTime milis style=\"short\"}}|{{formatTime localDateTime style=\"short\"}}").render((Object)data));
        Assert.assertEquals((Object)Strings.repeat((String)expectedCustom, (int)4, (String)"|"), (Object)this.engine.compileMustache("time_helper_custom", "{{formatTime calendar pattern=\"DD-MM-yyyy HH:mm\"}}|{{formatTime date pattern=\"DD-MM-yyyy HH:mm\"}}|{{formatTime milis pattern=\"DD-MM-yyyy HH:mm\"}}|{{formatTime localDateTime pattern=\"DD-MM-yyyy HH:mm\"}}").render((Object)data));
    }

    @Test
    public void testTimezone() {
        Calendar day = this.day();
        day.setTimeZone(TimeZone.getTimeZone("Europe/Prague"));
        String expectedCustom = "01-01-2013 12:00";
        Assert.assertEquals((Object)expectedCustom, (Object)this.engine.compileMustache("time_helper_timezone", "{{formatTime day pattern=\"DD-MM-yyyy HH:mm\" timeZone=\"Europe/London\"}}").render((Object)ImmutableMap.of((Object)"day", (Object)day)));
    }

    @Test
    public void testLocale() {
        Calendar day = this.day();
        String expectedCustom = "Led 01-01-2013";
        Assert.assertEquals((Object)expectedCustom, (Object)this.engine.compileMustache("time_helper_locale", "{{formatTime this pattern=\"MMM DD-MM-yyyy\" locale='cs'}}").render((Object)day));
    }

    private Calendar day() {
        Calendar day = Calendar.getInstance();
        day.set(1, 2013);
        day.set(2, 0);
        day.set(5, 1);
        day.set(11, 13);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        return day;
    }
}

