/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;

@Internal
public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    private IOUtils() {
    }

    public static String toString(Reader input) throws IOException {
        return IOUtils.toString(input, 2048);
    }

    public static String toString(Reader input, int bufferSize) throws IOException {
        return IOUtils.toString(input, bufferSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Reader input, int bufferSize, boolean close) throws IOException {
        Checker.checkArgumentNotNull(input);
        StringBuilder builder = new StringBuilder();
        try {
            IOUtils.copy(input, builder, bufferSize);
        }
        finally {
            if (close) {
                input.close();
            }
        }
        return builder.toString();
    }

    public static void copy(Readable in, Appendable out, int bufferSize) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(bufferSize);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.append(buffer);
            buffer.clear();
        }
    }
}

