/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.util.Patterns;
import org.trimou.util.Strings;

public class DefaultLiteralSupport
extends AbstractConfigurationAware
implements LiteralSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLiteralSupport.class);
    private final Pattern integerLiteralPattern = Patterns.newHelperIntegerLiteralPattern();
    private final Pattern longLiteralPattern = Patterns.newHelperLongLiteralPattern();

    @Override
    public Object getLiteral(String value, MustacheTagInfo tagInfo) {
        if (Strings.isEmpty(value)) {
            return null;
        }
        Object literal = null;
        if (Strings.isStringLiteralSeparator(value.charAt(0))) {
            literal = value.substring(1, value.length() - 1);
        } else if (value.equals("true")) {
            literal = Boolean.TRUE;
        } else if (value.equals("false")) {
            literal = Boolean.FALSE;
        } else if (this.integerLiteralPattern.matcher(value).matches()) {
            try {
                literal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to parse integer literal: " + value, (Throwable)e);
            }
        } else if (this.longLiteralPattern.matcher(value).matches()) {
            try {
                literal = Long.parseLong(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to parse long literal: " + value, (Throwable)e);
            }
        }
        return literal;
    }
}

