/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.trimou.Mustache;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.listener.AbstractStatsCollector;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;
import org.trimou.util.ImmutableSet;

public class EnhancedStatsCollector
extends AbstractStatsCollector {
    public static final String COMPUTING_CACHE_CONSUMER_ID = EnhancedStatsCollector.class.getName();
    private final ConcurrentMap<Long, String> idsToNames = new ConcurrentHashMap<Long, String>();
    protected ComputingCache<Long, ConcurrentMap<Long, ExecutionData>> data;

    public EnhancedStatsCollector() {
        this(null, null);
    }

    public EnhancedStatsCollector(Predicate<String> templatePredicate, TimeUnit timeUnit) {
        super(templatePredicate, timeUnit);
    }

    @Override
    public void renderingStarted(MustacheRenderingEvent event) {
        if (this.isApplied(event.getMustacheName())) {
            this.idsToNames.putIfAbsent(event.getMustacheGeneratedId(), event.getMustacheName());
            this.data.get(event.getMustacheGeneratedId()).put(event.getGeneratedId(), new ExecutionData(System.nanoTime()));
        }
    }

    @Override
    public void renderingFinished(MustacheRenderingEvent event) {
        if (this.isApplied(event.getMustacheName())) {
            ((ExecutionData)this.data.get(event.getMustacheGeneratedId()).get(event.getGeneratedId())).setEnd(System.nanoTime());
        }
    }

    @Override
    protected void init() {
        this.data = this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, new ComputingCache.Function<Long, ConcurrentMap<Long, ExecutionData>>(){

            @Override
            public ConcurrentMap<Long, ExecutionData> compute(Long key) {
                return new ConcurrentHashMap<Long, ExecutionData>();
            }
        }, null, null, null);
    }

    public AbstractStatsCollector.Stats getStats(Mustache mustache) {
        Checker.checkArgumentNotNull(mustache);
        ConcurrentMap<Long, ExecutionData> times = this.data.getIfPresent(mustache.getGeneratedId());
        if (times != null) {
            return this.parseData(mustache.getName(), mustache.getGeneratedId(), times.values());
        }
        return null;
    }

    public Set<AbstractStatsCollector.Stats> getStats() {
        ImmutableSet.ImmutableSetBuilder<AbstractStatsCollector.Stats> builder = ImmutableSet.builder();
        for (Map.Entry<Long, ConcurrentMap<Long, ExecutionData>> entry : this.data.getAllPresent().entrySet()) {
            builder.add(this.parseData((String)this.idsToNames.get(entry.getKey()), entry.getKey(), entry.getValue().values()));
        }
        return builder.build();
    }

    public Collection<ExecutionData> getRawData(Mustache mustache) {
        Checker.checkArgumentNotNull(mustache);
        ConcurrentMap<Long, ExecutionData> executions = this.data.getIfPresent(mustache.getGeneratedId());
        if (executions != null) {
            return ImmutableMap.copyOf(executions).values();
        }
        return null;
    }

    public void clearData() {
        this.data.clear();
    }

    private AbstractStatsCollector.Stats parseData(String mustacheName, long mustacheId, Collection<ExecutionData> executions) {
        long errors = 0L;
        long finished = 0L;
        long totalTime = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        for (ExecutionData execution : executions) {
            if (execution.isFinished()) {
                long value = this.convert(execution.getValue());
                ++finished;
                totalTime += value;
                if (value > maxTime) {
                    maxTime = value;
                }
                if (value >= minTime) continue;
                minTime = value;
                continue;
            }
            ++errors;
        }
        long meanTime = totalTime / finished;
        return new AbstractStatsCollector.Stats(mustacheId, mustacheName, finished, errors, totalTime, meanTime, minTime, maxTime);
    }

    public static class ExecutionData {
        private final long start;
        private Long end;

        ExecutionData(long start) {
            this.start = start;
        }

        void setEnd(long end) {
            this.end = end;
        }

        boolean isFinished() {
            return this.end != null;
        }

        long getValue() {
            return this.end - this.start;
        }
    }
}

