/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.text;

import java.io.IOException;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.text.TextSupport;
import org.trimou.util.Checker;
import org.trimou.util.Escaper;

public class DefaultTextSupport
extends AbstractConfigurationAware
implements TextSupport {
    private final Escaper escaper;

    public DefaultTextSupport() {
        this(Escaper.builder().add('\"', "&quot;").add('\'', "&#39;").add('&', "&amp;").add('<', "&lt;").add('>', "&gt;").build());
    }

    public DefaultTextSupport(Escaper escaper) {
        Checker.checkArgumentNotNull(escaper);
        this.escaper = escaper;
    }

    @Override
    public String escapeHtml(String input) {
        return this.escaper.escape(input);
    }

    @Override
    public void appendEscapedHtml(String input, Appendable appendable) throws IOException {
        this.escaper.escape(input, appendable);
    }
}

