/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.segment.ImmutableIterationMeta;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Function;
import org.trimou.handlebars.Options;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Iterables;

public class EachHelper
extends BasicSectionHelper {
    public static final String SKIP_RESULT = "org.trimou.handlebars.skipResult";
    private String iterationMetadataAlias;

    @Override
    public void init() {
        super.init();
        this.iterationMetadataAlias = this.configuration.getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS);
    }

    @Override
    public void execute(Options options) {
        if (options.getParameters().size() == 1) {
            Object param = options.getParameters().get(0);
            if (param == null) {
                return;
            }
            this.processParameter(param, options, 1, this.getSize(param));
        } else {
            int size = 0;
            int index = 1;
            ArrayList<Object> params = new ArrayList<Object>(options.getParameters());
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int paramSize = 0;
                if (e != null) {
                    paramSize = this.getSize(e);
                }
                if (paramSize > 0) {
                    size += paramSize;
                    continue;
                }
                iterator.remove();
            }
            if (size == 0) {
                return;
            }
            for (Object e : params) {
                index = this.processParameter(e, options, index, size);
            }
        }
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("apply", "as");
    }

    private int processParameter(Object param, Options options, int index, int size) {
        if (param instanceof Iterable) {
            return this.processIterable((Iterable)param, options, index, size);
        }
        if (param.getClass().isArray()) {
            return this.processArray(param, options, index, size);
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is nor an Iterable nor an array [%s]", param, options.getTagInfo());
    }

    private int processIterable(Iterable<?> iterable, Options options, int index, int size) {
        Iterator<?> iterator = iterable.iterator();
        Function function = this.initFunction(options);
        String alias = this.initValueAlias(options);
        while (iterator.hasNext()) {
            this.nextElement(options, iterator.next(), size, index++, function, alias);
        }
        return index;
    }

    private int processArray(Object array, Options options, int index, int size) {
        int length = Array.getLength(array);
        Function function = this.initFunction(options);
        String alias = this.initValueAlias(options);
        for (int i = 0; i < length; ++i) {
            this.nextElement(options, Array.get(array, i), size, index++, function, alias);
        }
        return index;
    }

    private int getSize(Object param) {
        if (param instanceof Iterable) {
            return Iterables.size((Iterable)param);
        }
        if (param.getClass().isArray()) {
            return Array.getLength(param);
        }
        return 0;
    }

    private void nextElement(Options options, Object value, int size, int index, Function function, String valueAlias) {
        if (function != null && SKIP_RESULT.equals(value = function.apply(value))) {
            return;
        }
        if (valueAlias != null) {
            options.push(new ImmutableIterationMeta(this.iterationMetadataAlias, size, index, valueAlias, value));
            options.fn();
            options.pop();
        } else {
            options.push(new ImmutableIterationMeta(this.iterationMetadataAlias, size, index));
            options.push(value);
            options.fn();
            options.pop();
            options.pop();
        }
    }

    private Function initFunction(Options options) {
        Object function = options.getHash().get("apply");
        if (function == null) {
            return null;
        }
        if (function instanceof Function) {
            return (Function)function;
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is not a valid function [%s]", function, options.getTagInfo());
    }

    private String initValueAlias(Options options) {
        Object as = options.getHash().get("as");
        if (as == null) {
            return null;
        }
        return as.toString();
    }
}

