/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.util.Locale;
import java.util.Set;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.handlebars.BasicValueHelper;
import org.trimou.handlebars.Options;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Locales;

public abstract class LocaleAwareValueHelper
extends BasicValueHelper {
    private volatile LocaleSupport localeSupport;

    @Override
    protected void init() {
        super.init();
        this.localeSupport = this.configuration.getLocaleSupport();
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("locale");
    }

    protected Locale getCurrentLocale() {
        return this.getCurrentLocale(null);
    }

    protected Locale getCurrentLocale(Options options) {
        if (options != null) {
            return this.localeSupport.getCurrentLocale((String k) -> options.getValue(k));
        }
        return this.localeSupport.getCurrentLocale();
    }

    protected Locale getLocale(Options options) {
        Object localeObject = options.getHash().get("locale");
        if (localeObject == null) {
            localeObject = options.getValue("locale");
        }
        Locale locale = localeObject != null ? Locales.getLocale(localeObject) : this.getCurrentLocale(options);
        return locale;
    }
}

