/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.lambda;

import java.util.function.Function;
import org.trimou.lambda.Lambda;
import org.trimou.util.Checker;

public final class SimpleLambdas {
    private SimpleLambdas() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Lambda invoke(Function<String, String> invokeCallback) {
        return SimpleLambdas.builder().interpolateReturnValue().inputType(Lambda.InputType.LITERAL).invoke(invokeCallback).build();
    }

    static class SimpleLambda
    implements Lambda {
        private final Lambda.InputType inputType;
        private final Function<String, String> invokeCallback;
        private final boolean isReturnValueInterpolated;

        private SimpleLambda(Lambda.InputType inputType, Function<String, String> invokeCallback, boolean isReturnValueInterpolated) {
            Checker.checkArgumentNotNull((Object)inputType);
            Checker.checkArgumentNotNull(invokeCallback);
            this.inputType = inputType;
            this.invokeCallback = invokeCallback;
            this.isReturnValueInterpolated = isReturnValueInterpolated;
        }

        @Override
        public String invoke(String text) {
            return this.invokeCallback.apply(text);
        }

        @Override
        public Lambda.InputType getInputType() {
            return this.inputType;
        }

        @Override
        public boolean isReturnValueInterpolated() {
            return this.isReturnValueInterpolated;
        }
    }

    public static class Builder {
        private Lambda.InputType inputType = Lambda.InputType.LITERAL;
        private Function<String, String> invokeCallback;
        private boolean isReturnValueInterpolated = false;

        private Builder() {
        }

        public Builder interpolateReturnValue() {
            this.isReturnValueInterpolated = true;
            return this;
        }

        public Builder inputType(Lambda.InputType inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder invoke(Function<String, String> invokeCallback) {
            this.invokeCallback = invokeCallback;
            return this;
        }

        public Lambda build() {
            return new SimpleLambda(this.inputType, this.invokeCallback, this.isReturnValueInterpolated);
        }
    }
}

