/*
 * Decompiled with CFR 0.152.
 */
package org.trimou;

import org.junit.Assert;
import org.trimou.ExceptionAssert;
import org.trimou.exception.MustacheException;
import org.trimou.exception.ProblemCode;

public class MustacheExceptionAssert
extends ExceptionAssert<MustacheException> {
    private final ProblemCode expectedCode;
    private final String messageSubstring;

    private MustacheExceptionAssert(ProblemCode expectedCode) {
        super(MustacheException.class);
        this.expectedCode = expectedCode;
        this.messageSubstring = null;
    }

    private MustacheExceptionAssert(ProblemCode expectedCode, String messageSubstring) {
        super(MustacheException.class);
        this.expectedCode = expectedCode;
        this.messageSubstring = messageSubstring;
    }

    @Override
    protected void checkException(MustacheException e) {
        if (!e.getCode().equals(this.expectedCode)) {
            Assert.fail((String)("Unexpected problem code: " + e.getCode()));
        }
        if (this.messageSubstring != null && !e.getMessage().contains(this.messageSubstring)) {
            Assert.fail((String)String.format("expected message with substring [%s], got [%s]", this.messageSubstring, e.getMessage()));
        }
    }

    public static MustacheExceptionAssert expect(ProblemCode code) {
        return new MustacheExceptionAssert(code);
    }

    public static MustacheExceptionAssert expect(ProblemCode code, String messageSubstring) {
        return new MustacheExceptionAssert(code, messageSubstring);
    }
}

