/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.engine.resolver.Mapper;
import org.trimou.util.ImmutableMap;

public class MapResolverTest
extends AbstractEngineTest {
    @Test
    public void testResolution() {
        MapResolver resolver = new MapResolver();
        Assert.assertNull((Object)resolver.resolve(null, "foo", null));
        Assert.assertNotNull((Object)resolver.resolve((Object)ImmutableMap.of((Object)"bar", (Object)"baz"), "bar", null));
        Assert.assertNull((Object)resolver.resolve((Object)ImmutableMap.of((Object)"bar", (Object)"baz"), "qux", null));
    }

    @Test
    public void testInterpolation() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("foo", 1);
        map.put("bar", 2);
        Mapper mapper = key -> "foo".equals(key) ? Integer.valueOf(10) : null;
        Map data = ImmutableMap.of((Object)"map", map, (Object)"mapper", (Object)mapper);
        String templateContents = "Hello {{map.foo}} or {{map.bar}}!|{{map.nonExisting}} {{mapper.foo}}";
        Assert.assertEquals((Object)"Hello 1 or 2!| 10", (Object)this.engine.compileMustache("map", templateContents).render((Object)data));
    }
}

