/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.math.BigDecimal;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Hammer;
import org.trimou.Mustache;
import org.trimou.util.ImmutableMap;

public class InvertedSectionSegmentTest
extends AbstractEngineTest {
    @Test
    public void testBoolean() {
        String templateContents = "Hello {{^test}}me{{/test}}!";
        Mustache mustache = this.engine.compileMustache("boolean", templateContents);
        Assert.assertEquals((Object)"Hello me!", (Object)mustache.render((Object)ImmutableMap.of((Object)"test", (Object)false)));
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render((Object)ImmutableMap.of((Object)"test", (Object)true)));
    }

    @Test
    public void testIterable() {
        String templateContents = "{{^numbers}}Hey!{{/numbers}}";
        Mustache mustache = this.engine.compileMustache("iterable", templateContents);
        Assert.assertEquals((Object)"Hey!", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", Collections.emptyList())));
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", Collections.singleton(1))));
    }

    @Test
    public void testArray() {
        String templateContents = "{{^numbers}}Hey!{{/numbers}}";
        Mustache mustache = this.engine.compileMustache("iterable", templateContents);
        Assert.assertEquals((Object)"Hey!", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new Object[0])));
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new String[]{"Hello"})));
    }

    @Test
    public void testNestedContext() {
        String templateContents = "Hello {{^test}}ping{{/test}}!";
        Mustache mustache = this.engine.compileMustache("nested", templateContents);
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render((Object)ImmutableMap.of((Object)"test", (Object)new Hammer())));
        Assert.assertEquals((Object)"Hello ping!", (Object)mustache.render(Collections.singletonMap("test", null)));
    }

    @Test
    public void testNumber() {
        String templateContents = "Hello {{^this}}ping{{/this}}!";
        Mustache mustache = this.engine.compileMustache("number", templateContents);
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render((Object)new BigDecimal("0.1")));
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render((Object)BigDecimal.ZERO));
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render((Object)0L));
    }
}

