/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.Mustache;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.CacheHelper;
import org.trimou.handlebars.HelpersBuilder;

public class CacheHelperTest
extends AbstractTest {
    @Test
    public void testHelper() throws InterruptedException {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addCache().build()).build();
        CacheHelper cacheHelper = (CacheHelper)engine.getConfiguration().getHelpers().get("cache");
        final AtomicInteger hits = new AtomicInteger();
        Mustache mustache = engine.compileMustache("cache_01", "{{#cache}}{{this.age}}{{/cache}}");
        Hammer hammer = new Hammer(){

            @Override
            public Integer getAge() {
                hits.incrementAndGet();
                return super.getAge();
            }
        };
        Assert.assertEquals((Object)"10", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((Object)"10", (Object)mustache.render((Object)hammer));
        hammer.setAge(11);
        Assert.assertEquals((Object)"10", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((long)1L, (long)hits.get());
        cacheHelper.invalidateFragments();
        hammer.setAge(1);
        mustache = engine.compileMustache("cache_02", "{{#cache expire=1 unit='MILLISECONDS'}}{{this.age}}{{/cache}}");
        Assert.assertEquals((Object)"1", (Object)mustache.render((Object)hammer));
        Thread.sleep(50L);
        hammer.setAge(2);
        Assert.assertEquals((Object)"2", (Object)mustache.render((Object)hammer));
        cacheHelper.invalidateFragments();
        hammer.setAge(5);
        mustache = engine.compileMustache("cache_03", "{{#cache guard=this.age}}{{this.age}}{{/cache}}");
        Assert.assertEquals((Object)"5", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((Object)"5", (Object)mustache.render((Object)hammer));
        hammer.setAge(50);
        Assert.assertEquals((Object)"50", (Object)mustache.render((Object)hammer));
        cacheHelper.invalidateFragments();
        mustache = engine.compileMustache("cache_04", "{{#cache key=this.id}}{{this.age}}{{/cache}}");
        hammer.setAge(1000);
        Hammer hammer2 = new Hammer(2000){

            @Override
            public Integer getAge() {
                hits.incrementAndGet();
                return super.getAge();
            }
        };
        Hammer hammer3 = new Hammer(3000){

            @Override
            public Integer getAge() {
                hits.incrementAndGet();
                return super.getAge();
            }
        };
        Assert.assertEquals((Object)"1000", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((Object)"2000", (Object)mustache.render((Object)hammer2));
        Assert.assertEquals((Object)"3000", (Object)mustache.render((Object)hammer3));
        hammer.setAge(1001);
        hammer2.setAge(2001);
        hammer3.setAge(3001);
        Assert.assertEquals((Object)"1000", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((Object)"2000", (Object)mustache.render((Object)hammer2));
        Assert.assertEquals((Object)"3000", (Object)mustache.render((Object)hammer3));
        cacheHelper.invalidateFragments(hammer.getId());
        Assert.assertEquals((Object)"1001", (Object)mustache.render((Object)hammer));
        Assert.assertEquals((Object)"2000", (Object)mustache.render((Object)hammer2));
        Assert.assertEquals((Object)"3000", (Object)mustache.render((Object)hammer3));
    }

    @Test
    public void testHelperConfiguration() throws InterruptedException {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setProperty(CacheHelper.FRAGMENT_CACHE_MAX_SIZE_KEY, (Object)0).registerHelpers(HelpersBuilder.empty().addCache().build()).build();
        Hammer hammer1 = new Hammer(1);
        Hammer hammer2 = new Hammer(2);
        Hammer hammer3 = new Hammer(3);
        Mustache mustache = engine.compileMustache("cache_config_01", "{{#cache key=this.id}}{{this.age}}{{/cache}}");
        Assert.assertEquals((Object)"1", (Object)mustache.render((Object)hammer1));
        Assert.assertEquals((Object)"2", (Object)mustache.render((Object)hammer2));
        Assert.assertEquals((Object)"3", (Object)mustache.render((Object)hammer3));
        hammer1.setAge(11);
        hammer2.setAge(22);
        hammer3.setAge(33);
        Assert.assertEquals((Object)"11", (Object)mustache.render((Object)hammer1));
        Assert.assertEquals((Object)"22", (Object)mustache.render((Object)hammer2));
        Assert.assertEquals((Object)"33", (Object)mustache.render((Object)hammer3));
    }

    @Test
    public void testValidation() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addCache().build()).build().compileMustache("cache_validation_01", "{{cache}}")).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addCache().build()).build().compileMustache("cache_validation_02", "{{#cache expire='foo'}}{{/cache}}")).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addCache().build()).build().compileMustache("cache_validation_03", "{{#cache expire=1 unit='foo'}}{{/cache}}"));
    }
}

