/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.handlebars.LogHelper;

public class LogHelperTest
extends AbstractTest {
    @Test
    public void testLogHelper() {
        String name = "MyLogger";
        TestLoggerAdapter adapter = new TestLoggerAdapter(name);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().add("log", (Helper)LogHelper.builder().setDefaultLevel(LogHelper.Level.INFO).setLoggerAdapter((LogHelper.LoggerAdapter)adapter).build()).build()).build();
        String msg = "Hello me!";
        engine.compileMustache("log_helper1", "{{log \"" + msg + "\" level=\"WARN\"}}").render(null);
        Assert.assertEquals((Object)LogHelper.Level.WARN, (Object)adapter.getLevels().get(0));
        Assert.assertEquals((Object)(msg + " [log_helper1:1]"), (Object)adapter.getMessages().get(0));
        Assert.assertEquals((long)adapter.getParameters().get(0).length, (long)0L);
        msg = "Hello {}!";
        engine.compileMustache("log_helper2", "{{log this \"me\"}}").render((Object)msg);
        Assert.assertEquals((Object)LogHelper.Level.INFO, (Object)adapter.getLevels().get(1));
        Assert.assertEquals((Object)(msg + " [log_helper2:1]"), (Object)adapter.getMessages().get(1));
        Assert.assertEquals((long)adapter.getParameters().get(1).length, (long)1L);
        engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().add("log", (Helper)LogHelper.builder().setAppendTemplateInfo(false).setDefaultLevel(LogHelper.Level.INFO).setLoggerAdapter((LogHelper.LoggerAdapter)adapter).build()).build()).build();
        engine.compileMustache("log_helper3", "{{log \"" + msg + "\"}}").render(null);
        Assert.assertEquals((Object)LogHelper.Level.INFO, (Object)adapter.getLevels().get(2));
        Assert.assertEquals((Object)msg, (Object)adapter.getMessages().get(2));
        Assert.assertEquals((long)adapter.getParameters().get(2).length, (long)0L);
    }

    @Test
    public void testLogHelperValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().add("log", (Helper)LogHelper.builder().build()).build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("log_helper_validation01", "{{#log \"Foo\"}}{{/log}}")).check(() -> engine.compileMustache("log_helper_validation02", "{{log}}"));
    }

    private static class TestLoggerAdapter
    extends LogHelper.Slf4jLoggerAdapter {
        final List<LogHelper.Level> levels = new ArrayList<LogHelper.Level>();
        final List<String> messages = new ArrayList<String>();
        final List<Object[]> parameters = new ArrayList<Object[]>();

        public TestLoggerAdapter(String name) {
            super(name);
        }

        public void log(LogHelper.Level level, String message, Object[] params) {
            super.log(level, message, params);
            this.levels.add(level);
            this.messages.add(message);
            this.parameters.add(params);
        }

        public List<LogHelper.Level> getLevels() {
            return this.levels;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public List<Object[]> getParameters() {
            return this.parameters;
        }
    }
}

