/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.MustacheCompilationEvent;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheParsingEvent;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.ParserFactory;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.parser.ParsingHandlerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.IOUtils;

class DefaultMustacheEngine
implements MustacheEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMustacheEngine.class);
    private final ComputingCache<String, Optional<Mustache>> templateCache;
    private final ComputingCache<String, Optional<String>> sourceCache;
    private final Configuration configuration;
    private final ParserFactory parserFactory;
    private final ParsingHandlerFactory parsingHandlerFactory;

    DefaultMustacheEngine() {
        this.configuration = null;
        this.parserFactory = null;
        this.parsingHandlerFactory = null;
        this.templateCache = null;
        this.sourceCache = null;
    }

    DefaultMustacheEngine(MustacheEngineBuilder builder) {
        this.configuration = new ConfigurationFactory().createConfiguration(builder);
        this.parserFactory = new ParserFactory();
        this.parsingHandlerFactory = new ParsingHandlerFactory();
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE).booleanValue()) {
            this.templateCache = null;
            this.sourceCache = null;
            LOGGER.warn("Attention! Debug mode enabled: template cache disabled, additional logging enabled");
        } else if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_ENABLED).booleanValue()) {
            this.templateCache = this.buildTemplateCache();
            ComputingCache<String, Optional<String>> computingCache = this.sourceCache = this.configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_USED_FOR_SOURCE) != false ? this.buildSourceCache() : null;
            if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES).booleanValue()) {
                this.precompileTemplates();
            }
        } else {
            this.templateCache = null;
            this.sourceCache = null;
            LOGGER.info("Template cache explicitly disabled!");
        }
    }

    @Override
    public Mustache getMustache(String templateId) {
        Checker.checkArgumentNotEmpty(templateId);
        return this.templateCache != null ? this.getTemplateFromCache(templateId) : this.locateAndParse(templateId);
    }

    @Override
    public String getMustacheSource(String templateId) {
        Checker.checkArgumentNotEmpty(templateId);
        return this.sourceCache != null ? this.getSourceFromCache(templateId) : this.locateAndRead(templateId);
    }

    @Override
    public Mustache compileMustache(String templateId, String templateContent) {
        Checker.checkArgumentNotEmpty(templateId);
        Checker.checkArgumentNotEmpty(templateContent);
        return this.parse(templateId, new StringReader(templateContent));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void invalidateTemplateCache() {
        if (this.isCacheEnabled()) {
            this.templateCache.clear();
            if (this.sourceCache != null) {
                this.sourceCache.clear();
            }
        }
    }

    @Override
    public void invalidateTemplateCache(Predicate<String> predicate) {
        if (this.isCacheEnabled()) {
            Checker.checkArgumentNotNull(predicate);
            this.templateCache.invalidate(predicate::test);
            if (this.sourceCache != null) {
                this.sourceCache.invalidate(predicate::test);
            }
        }
    }

    private boolean isCacheEnabled() {
        if (this.templateCache == null) {
            LOGGER.warn("Unable to invalidate the template cache - it's disabled!");
            return false;
        }
        return true;
    }

    private ComputingCache<String, Optional<Mustache>> buildTemplateCache() {
        return this.buildCache("Template", key -> Optional.ofNullable(this.locateAndParse((String)key)), (key, cause) -> LOGGER.debug("Removed template from cache [templateId: {}, cause: {}]", key, (Object)cause));
    }

    private ComputingCache<String, Optional<String>> buildSourceCache() {
        return this.buildCache("Source", key -> Optional.ofNullable(this.locateAndRead((String)key)), (key, cause) -> LOGGER.debug("Removed template source from cache [templateId: {}, cause: {}]", key, (Object)cause));
    }

    private <K, V> ComputingCache<K, V> buildCache(String name, ComputingCache.Function<K, V> loader, ComputingCache.Listener<K> listener) {
        Long expirationTimeout = this.configuration.getLongPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT);
        if (expirationTimeout > 0L) {
            LOGGER.info("{} cache expiration timeout set: {} seconds", (Object)name, (Object)expirationTimeout);
            expirationTimeout = expirationTimeout * 1000L;
        } else {
            expirationTimeout = null;
        }
        return this.configuration.getComputingCacheFactory().create(MustacheEngine.COMPUTING_CACHE_CONSUMER_ID, loader, expirationTimeout, null, listener);
    }

    private void precompileTemplates() {
        HashSet<String> templateNames = new HashSet<String>();
        for (TemplateLocator locator : this.configuration.getTemplateLocators()) {
            templateNames.addAll(locator.getAllIdentifiers());
        }
        for (String templateName : templateNames) {
            this.getTemplateFromCache(templateName);
        }
    }

    private Mustache parse(String templateId, Reader reader) {
        ParsingHandler handler = this.parsingHandlerFactory.createParsingHandler();
        reader = this.notifyListenersBeforeParsing(templateId, reader);
        this.parserFactory.createParser(this).parse(templateId, reader, handler);
        Mustache mustache = handler.getCompiledTemplate();
        this.notifyListenersAfterCompilation(mustache);
        return mustache;
    }

    private Reader locate(String templateId) {
        TemplateLocator locator;
        List<TemplateLocator> locators = this.configuration.getTemplateLocators();
        if (locators == null || locators.isEmpty()) {
            return null;
        }
        Reader reader = null;
        Iterator<TemplateLocator> iterator = locators.iterator();
        while (iterator.hasNext() && (reader = (locator = iterator.next()).locate(templateId)) == null) {
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mustache locateAndParse(String templateId) {
        Reader reader = null;
        try {
            reader = this.locate(templateId);
            if (reader == null) {
                Mustache mustache = null;
                return mustache;
            }
            Mustache mustache = this.parse(templateId, reader);
            return mustache;
        }
        finally {
            this.closeReader(reader, templateId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String locateAndRead(String templateId) {
        Reader reader = null;
        try {
            reader = this.locate(templateId);
            if (reader == null) {
                String string = null;
                return string;
            }
            String string = IOUtils.toString(reader);
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.closeReader(reader, templateId);
        }
    }

    private void closeReader(Reader reader, String templateId) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close the reader for " + templateId, (Throwable)e);
            }
        }
    }

    private Reader notifyListenersBeforeParsing(String templateName, Reader reader) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheParsingEvent event = new DefaultMustacheParsingEvent(templateName, reader);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.parsingStarted(event);
            }
            return event.getMustacheContents();
        }
        return reader;
    }

    private void notifyListenersAfterCompilation(Mustache mustache) {
        if (this.configuration.getMustacheListeners() != null) {
            DefaultMustacheCompilationEvent event = new DefaultMustacheCompilationEvent(mustache);
            for (MustacheListener listener : this.configuration.getMustacheListeners()) {
                listener.compilationFinished(event);
            }
        }
    }

    private Mustache getTemplateFromCache(String templateName) {
        try {
            return this.templateCache.get(templateName).orElse(null);
        }
        catch (Exception e) {
            throw this.unwrapUncheckedExecutionException(e);
        }
    }

    private String getSourceFromCache(String templateName) {
        try {
            return this.sourceCache.get(templateName).orElse(null);
        }
        catch (Exception e) {
            throw this.unwrapUncheckedExecutionException(e);
        }
    }

    private RuntimeException unwrapUncheckedExecutionException(Exception e) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, cause);
    }

    private static class DefaultMustacheParsingEvent
    implements MustacheParsingEvent {
        private final String mustacheName;
        private Reader reader;

        public DefaultMustacheParsingEvent(String mustacheName, Reader reader) {
            this.mustacheName = mustacheName;
            this.reader = reader;
        }

        @Override
        public String getMustacheName() {
            return this.mustacheName;
        }

        @Override
        public Reader getMustacheContents() {
            return this.reader;
        }

        @Override
        public void setMustacheContents(Reader reader) {
            this.reader = reader;
        }
    }

    private static class DefaultMustacheCompilationEvent
    implements MustacheCompilationEvent {
        private final Mustache mustache;

        public DefaultMustacheCompilationEvent(Mustache mustache) {
            this.mustache = mustache;
        }

        @Override
        public Mustache getMustache() {
            return this.mustache;
        }
    }
}

