/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.DefaultMustacheEngine;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.convert.ValueConverter;
import org.trimou.engine.id.IdentifierGenerator;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.handlebars.Helper;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Strings;

public final class MustacheEngineBuilder
implements ConfigurationExtension.ConfigurationExtensionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MustacheEngineBuilder.class);
    private static final String BUILD_PROPERTIES_FILE = "/trimou-build.properties";
    private boolean isBuilt;
    private boolean omitServiceLoaderConfigurationExtensions = false;
    private final Set<Resolver> resolvers = new HashSet<Resolver>();
    private final Set<TemplateLocator> templateLocators = new HashSet<TemplateLocator>();
    private final Map<String, Object> globalData = new HashMap<String, Object>();
    private TextSupport textSupport;
    private LocaleSupport localeSupport;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<EngineBuiltCallback> engineReadyCallbacks;
    private final List<MustacheListener> mustacheListeners = new ArrayList<MustacheListener>();
    private KeySplitter keySplitter;
    private MissingValueHandler missingValueHandler;
    private final Map<String, Helper> helpers = new HashMap<String, Helper>();
    private ComputingCacheFactory computingCacheFactory;
    private IdentifierGenerator identifierGenerator;
    private ExecutorService executorService;
    private LiteralSupport literalSupport;
    private ClassLoader configurationExtensionClassLoader;
    private final Set<ValueConverter> valueConverters;

    private MustacheEngineBuilder() {
        this.engineReadyCallbacks = new ArrayList<EngineBuiltCallback>();
        this.valueConverters = new HashSet<ValueConverter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MustacheEngine build() {
        int idx;
        String timestamp;
        String version;
        DefaultMustacheEngine engine;
        block10: {
            engine = new DefaultMustacheEngine(this);
            for (EngineBuiltCallback callback : this.engineReadyCallbacks) {
                callback.engineBuilt(engine);
            }
            version = null;
            timestamp = null;
            try {
                InputStream in = MustacheEngineBuilder.class.getResourceAsStream(BUILD_PROPERTIES_FILE);
                if (in == null) break block10;
                try {
                    Properties buildProperties = new Properties();
                    buildProperties.load(in);
                    version = buildProperties.getProperty("version");
                    timestamp = buildProperties.getProperty("timestamp");
                }
                finally {
                    in.close();
                }
            }
            catch (IOException in) {
                // empty catch block
            }
        }
        if (version == null) {
            Package pack = MustacheEngineBuilder.class.getPackage();
            version = pack.getSpecificationVersion();
            timestamp = pack.getImplementationVersion();
        }
        if (Strings.isEmpty(version)) {
            version = "SNAPSHOT";
        }
        if (Strings.isEmpty(timestamp)) {
            timestamp = "n/a";
        }
        if ((idx = timestamp.indexOf(84)) > 0) {
            timestamp = timestamp.substring(0, idx);
        }
        LOGGER.info("Engine built {} ({})", (Object)version, (Object)timestamp);
        LOGGER.debug("Engine configuration: {}", (Object)engine.getConfiguration().getInfo());
        this.isBuilt = true;
        return engine;
    }

    @Override
    public MustacheEngineBuilder addGlobalData(String name, Object value) {
        Checker.checkArgumentsNotNull(name, value);
        this.checkNotBuilt();
        this.globalData.put(name, value);
        return this;
    }

    public MustacheEngineBuilder addTemplateLocator(TemplateLocator locator) {
        Checker.checkArgumentNotNull(locator);
        this.checkNotBuilt();
        this.templateLocators.add(locator);
        return this;
    }

    @Override
    public MustacheEngineBuilder addResolver(Resolver resolver) {
        Checker.checkArgumentNotNull(resolver);
        this.checkNotBuilt();
        this.resolvers.add(resolver);
        return this;
    }

    public MustacheEngineBuilder setProperty(String key, Object value) {
        Checker.checkArgumentsNotNull(key, value);
        this.checkNotBuilt();
        this.properties.put(key, value);
        return this;
    }

    public <T extends ConfigurationKey> MustacheEngineBuilder setProperty(T configurationKey, Object value) {
        Checker.checkArgumentsNotNull(configurationKey, value);
        this.checkNotBuilt();
        this.setProperty(configurationKey.get(), value);
        return this;
    }

    public MustacheEngineBuilder setTextSupport(TextSupport textSupport) {
        Checker.checkArgumentNotNull(textSupport);
        this.checkNotBuilt();
        this.textSupport = textSupport;
        return this;
    }

    public MustacheEngineBuilder setLocaleSupport(LocaleSupport localeSupport) {
        Checker.checkArgumentNotNull(localeSupport);
        this.checkNotBuilt();
        this.localeSupport = localeSupport;
        return this;
    }

    public MustacheEngineBuilder registerCallback(EngineBuiltCallback callback) {
        Checker.checkArgumentNotNull(callback);
        this.checkNotBuilt();
        this.engineReadyCallbacks.add(callback);
        return this;
    }

    @Override
    public MustacheEngineBuilder addMustacheListener(MustacheListener listener) {
        Checker.checkArgumentNotNull(listener);
        this.checkNotBuilt();
        this.mustacheListeners.add(listener);
        return this;
    }

    public MustacheEngineBuilder setKeySplitter(KeySplitter keySplitter) {
        Checker.checkArgumentNotNull(keySplitter);
        this.checkNotBuilt();
        this.keySplitter = keySplitter;
        return this;
    }

    public MustacheEngineBuilder setMissingValueHandler(MissingValueHandler missingValueHandler) {
        Checker.checkArgumentNotNull(missingValueHandler);
        this.checkNotBuilt();
        this.missingValueHandler = missingValueHandler;
        return this;
    }

    @Override
    public MustacheEngineBuilder registerHelper(String name, Helper helper) {
        return this.registerHelper(name, helper, false);
    }

    @Override
    public MustacheEngineBuilder registerHelper(String name, Helper helper, boolean overwrite) {
        Checker.checkArgumentsNotNull(name, helper);
        this.checkNotBuilt();
        if (!overwrite && this.helpers.containsKey(name)) {
            throw new IllegalArgumentException("A helper with this name is already registered: " + name);
        }
        this.helpers.put(name, helper);
        return this;
    }

    @Override
    public MustacheEngineBuilder registerHelpers(Map<String, Helper> helpers) {
        return this.registerHelpers((Map)helpers, false);
    }

    @Override
    public MustacheEngineBuilder registerHelpers(Map<String, Helper> helpers, boolean overwrite) {
        Checker.checkArgumentNotNull(helpers);
        this.checkNotBuilt();
        for (Map.Entry<String, Helper> entry : helpers.entrySet()) {
            this.registerHelper(entry.getKey(), entry.getValue(), overwrite);
        }
        return this;
    }

    public MustacheEngineBuilder omitServiceLoaderConfigurationExtensions() {
        this.checkNotBuilt();
        this.omitServiceLoaderConfigurationExtensions = true;
        return this;
    }

    public MustacheEngineBuilder setComputingCacheFactory(ComputingCacheFactory cacheFactory) {
        Checker.checkArgumentNotNull(cacheFactory);
        this.checkNotBuilt();
        this.computingCacheFactory = cacheFactory;
        return this;
    }

    public MustacheEngineBuilder setIdentifierGenerator(IdentifierGenerator identifierGenerator) {
        Checker.checkArgumentNotNull(identifierGenerator);
        this.checkNotBuilt();
        this.identifierGenerator = identifierGenerator;
        return this;
    }

    public MustacheEngineBuilder setExecutorService(ExecutorService executorService) {
        Checker.checkArgumentNotNull(executorService);
        this.checkNotBuilt();
        this.executorService = executorService;
        return this;
    }

    public MustacheEngineBuilder setLiteralSupport(LiteralSupport literalSupport) {
        Checker.checkArgumentNotNull(literalSupport);
        this.checkNotBuilt();
        this.literalSupport = literalSupport;
        return this;
    }

    public MustacheEngineBuilder setConfigurationExtensionClassLoader(ClassLoader configurationExtensionClassLoader) {
        Checker.checkArgumentNotNull(configurationExtensionClassLoader);
        this.checkNotBuilt();
        this.configurationExtensionClassLoader = configurationExtensionClassLoader;
        return this;
    }

    @Override
    public MustacheEngineBuilder addValueConverter(ValueConverter converter) {
        Checker.checkArgumentNotNull(converter);
        this.checkNotBuilt();
        this.valueConverters.add(converter);
        return this;
    }

    public static MustacheEngineBuilder newBuilder() {
        return new MustacheEngineBuilder();
    }

    public Set<TemplateLocator> buildTemplateLocators() {
        return ImmutableSet.copyOf(this.templateLocators);
    }

    public Set<Resolver> buildResolvers() {
        return ImmutableSet.copyOf(this.resolvers);
    }

    public Map<String, Object> buildGlobalData() {
        return ImmutableMap.copyOf(this.globalData);
    }

    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    public boolean isOmitServiceLoaderConfigurationExtensions() {
        return this.omitServiceLoaderConfigurationExtensions;
    }

    public Map<String, Object> buildProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public List<MustacheListener> buildMustacheListeners() {
        return ImmutableList.copyOf(this.mustacheListeners);
    }

    public KeySplitter getKeySplitter() {
        return this.keySplitter;
    }

    public MissingValueHandler getMissingValueHandler() {
        return this.missingValueHandler;
    }

    public Map<String, Helper> buildHelpers() {
        return ImmutableMap.copyOf(this.helpers);
    }

    public ComputingCacheFactory getComputingCacheFactory() {
        return this.computingCacheFactory;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public LiteralSupport getLiteralSupport() {
        return this.literalSupport;
    }

    public ClassLoader getConfigurationExtensionClassLoader() {
        return this.configurationExtensionClassLoader;
    }

    public Set<ValueConverter> buildValueConverters() {
        return ImmutableSet.copyOf(this.valueConverters);
    }

    private void checkNotBuilt() {
        if (this.isBuilt) {
            throw new IllegalStateException("Invalid method invocation - builder already built!");
        }
    }

    @FunctionalInterface
    public static interface EngineBuiltCallback {
        public void engineBuilt(MustacheEngine var1);
    }
}

